//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//
//

#include <FL/gl.h>
#include <GL/glu.h>

#include <FTGL/ftgl.h>



#ifndef VIEW_LAYOUT_H
#define VIEW_LAYOUT_H



#define MAX_TEXT_SIZE   4096

//
// Define the plane outline limits function.
// These functions must provide the abscissas of the beginnings ...
// ... and ends of each line from the ordinate of the line.
//



class Spc_Layout {
public:

    // Define the limit function type.
    typedef GLdouble (Lim_Fnc)( GLdouble, void * );


private:

    static const int Max_Siz = MAX_TEXT_SIZE;

    typedef struct WORD * Wrd_Ptr;

    typedef struct WORD {       // One record for each word.
        int              idwd_, // Index of first byte of the word (can be a TAB).
                         lnwd_, // Length in byte of the word (if TAB its included).
                         llwd_; // Line number of the word.
        float            adwd_; // Length in 1/72" (Font unit).
    } Wrd_Rec;


    Wrd_Rec Wrd_Tab[Max_Siz/2]; // The word table.
    char       txtbuf[Max_Siz]; // To store the clean user string.

    Lim_Fnc     * bgf_, * enf_; // User functions to get X begin et X end of line.
    void                * dff_; // Secind arg. for functions bgf and enf.

    FTFont              * fnt_; // The used FTFont.

    GLdouble              tsc_, // The scale to apply (1/72 of inch * tsc_ = GL Ortho/ModelView unit).
                          mxw_, // The longest length of the word word.
                          txw_, // The advance for the full text in one line.
                          ali_, // Advance/Space for alinea value.
                          htl_, // Font LineHeight value.
                          asc_, // Font ascender value.
                          dsc_, // Font descender value.
                          adv_;

    int                   nwd_, // Number of found word.
                          lnb_; // Line number.

    GLdouble  crx_, cry_, crz_; // Point to render (GL coordinates).

    FTGL::TextAlignment   aln_; // Alignment choice.

    int  Work( bool );                  // Measure the text and Render if flag is on.

public:
    Spc_Layout();

    int  SetFont( FTFont * ft );

    FTFont * GetFont() { return fnt_; }

    void SetFLimits( Lim_Fnc * bf, Lim_Fnc * ef, void * d ) { bgf_ = bf; enf_ = ef; dff_ = d; }
    void SetLineHeight( GLdouble lh ) { htl_ = lh; }
    void SetAlignment( const FTGL::TextAlignment  al ) { aln_ = al; }
    void SetScale( GLdouble sc ) { tsc_ = sc; }
    void SetAlinea( GLdouble al ) { ali_ = al; }

    GLdouble Scale() { return tsc_; }
    GLdouble LineHeight() { return htl_; }
//  GLdouble Advance() { return adv_; }
    GLdouble Ascender() { return asc_; }
    GLdouble Descender() { return dsc_; }
    const FTGL::TextAlignment GetAlignment() { return aln_; }

    void Text_Parsing( const char *);   // Text parsing fonction to get and measure each word in the text.

    GLdouble StringMeasure(  GLdouble w, const char * t );

    GLdouble MaxWordAdvance() { return mxw_; }

    int Measure( const char *, GLdouble = 1.0e10 );
    int Render( const char * );

    GLdouble FillingLevel() { return cry_; }
    FTPoint BBUper() { return FTPoint( crx_, cry_, crz_ ); }

};



#endif


//
// end of <PW-Id>.
//

