



#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <string.h>


#include "Service_Util.h"
#include "Service_IO.h"





// User environment file space (depending of operating system).

#if defined( WINHOME ) || defined( WIN32 )
# define USER_ENV "LOCALAPPDATA:.DiaViewer,LOCALAPPDATA:"
# define USER_DIR "USERPROFILE:"
#else
# define USER_ENV "HOME:.DiaViewer,HOME:"
# define USER_DIR "HOME:"
#endif



static FilePath        FPath(); // Path to use to open the found file in the directory.




int SearchFont( const char * path )
{
    int ii, jj, ie;
    char          ch,  * entry;
    char             buf[1024];

    DIR                  * dir;
    struct dirent        * dsc;
    struct stat          entbf;


    CurrPath.Set( NULL, 0 );      // Open Directory without final DirSep.
    CPath.PathSearch( USER_DIR ); // Search the user directory.

    ii = 0;
    while (ch = path[ii]) {
        // We scan all path entries.
        jj = 0;
        while (ch && ch != ':' && ch != ';') {
            buf[jj++] = ch; ch =path[ii]
        }
        buf[jj++] = 0;          // Complete a directory entry.

        if (!(dir=opendir( buf ))) {
            printf( stderr, "\n  * DiaViewer Cannot open the directory :\n %s \n * %s => Scan Abort\n",
                            buf, /* PathString, */ strerror( errno ) );
        }

        while (dsc=readdir( dir )) {
            if (dsc->d_name[0]!='.') {  // Ignore all entry as ., .. and special dir/files.
                // Complete the path to get access to the entry (File or Directory).
                CurrPath.Set( dsc->d_name, 0 );
            }

        }




        }


    }

} // int SearchFont( const char * path ).




int main( inr argc, char ** argv )
{
    int nb = 0;

    if (argc <= 1) return 1;
    nb = SearchFont( argv[1] );
    printf( " We have found %d fonts\n", nb );

    return 0;
}

