//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//
//


//
// Define a user adjustable FTGL Layout for vectoriel font.
//


#include <stdio.h>
#include <string.h>


#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>
#include <FL/fl_message.H>
#include <FL/Fl_Gl_Window.H>

#include <FTGL/ftgl.h>

#include "View_Layout.h"



#define MAX_TEXT_SIZE   4096
#define NoTextLengthTest


//
//
//


Spc_Layout::Spc_Layout() {
    bgf_ = enf_ = 0;  fnt_ = 0;
    tsc_ = 1.0;  mxw_ = txw_ = 0.0;
    nwd_ = lnb_ = 0;
    ali_ = adv_ = htl_ = asc_ = dsc_ = 0.0;
} // Spc_Layout::Spc_Layout().



void Spc_Layout::Text_Parsing( const char * text )
{
    int   ii,  dw,  nw;
    GLdouble        ad;
    unsigned char   ch;
    const char    * cb;

    cb  = text;
    // We skip any rankind information.
    if (cb[0] == '*' && cb[1] == '[') {
        cb += 2;
        do { ch = *(cb++); } while (ch && ch != ']');
        ch = *(cb++);
        if (ch == '.' ) ch =*(cb++);
    }

#ifndef NoTextLengthTest

    if (strlen( cb ) >= Max_Siz) {
        fl_alert( "Too long text to be display, we Stop Task!");
        exit( 1 );
    }
#endif

    // Evaluate the surface to give for the text.

    mxw_ = 0;
    nw = ii = 0; dw = -1;
    ch = ' ';
    while (ch) {
        // Skip any space except TAB if the next char is > ' ' :
        if (ch <= ' ' && !(ch == '\t' && *cb > ' '))
            while (ch = *(cb++))
                if (ch > ' ' || (ch == '\t' && *cb > ' ')) break;
        // Any TAB just before a word is keep (ALinea mark)
        if (ch = '\t') { txtbuf[ii++] = '\t', ch = *(cb++); }

        if (ch) {                               // When a word is found except for the first ...
            if (nw) txtbuf[ii++] = ' ';         // ... one we keep one space between each word.
            dw = ii; txtbuf[ii++] = ch;
            while ((ch = *(cb++)) > ' ') txtbuf[ii++] = ch;
            Wrd_Tab[nw].idwd_ = dw;
            Wrd_Tab[nw].lnwd_ = ii - dw;
            Wrd_Tab[nw].llwd_ =  0;
            // The Advance for a word is in font units (not scaled to GL unit here).
            ad = tsc_*(fnt_->Advance( txtbuf+dw, Wrd_Tab[nw].lnwd_ ));
            Wrd_Tab[nw].adwd_ = ad;
            if (mxw_ < ad) mxw_ = ad;
            dw = -1; nw++;                  // A new word is append in the word table.
        }
    }
    txtbuf[ii] = 0;
    txw_ = tsc_*fnt_->Advance( txtbuf );
    nwd_ = nw;
} // Spc_Layout::Text_Parsing().



int  Spc_Layout::SetFont( FTFont * ft )
{
    crx_ = cry_ = 0.0;
    fnt_ =  ft;
    adv_ = 0.0;
    if (fnt_) {
        htl_ = tsc_*fnt_->LineHeight();
        asc_ = tsc_*fnt_->Ascender();
        dsc_ = tsc_*fnt_->Descender();
        ali_ = tsc_*fnt_->Advance( "    " ); // space for alinea = 4 space.
        return 1;
    } return 0;
} // void Spc_Layout::SetFont( FTFont * ft ).



GLdouble Spc_Layout::StringMeasure(  GLdouble w, const char * t )
{
    FTSimpleLayout l;
    FTBBox         b;

    l.SetLineLength( w/tsc_ );
    l.SetFont( fnt_ );
    l.SetAlignment( aln_ );
    b = l.BBox( t );
    // cw = d_tsc*(b.Upper().Xf() - b.Lower().Xf());
    return tsc_*(b.Upper().Yf() - b.Lower().Yf());
} // GLdouble Spc_Layout::StringAdvance( const char * t ).



int  Spc_Layout::Work( bool rflg )
{
    FTSimpleLayout        olay;
    FTBBox                obox;

    int ipw, ilw, iwd, jwd,
                  ibl, iel;
    bool  skl_, sta_, bgl_;

    GLdouble   xbe,  xen,  xxx,
              rem,  adw,  xorg;

    if (!(fnt_ && bgf_ && enf_ && nwd_)) return 0;

    if (rflg) glPushMatrix();

    if (rflg) {
        olay.SetFont( fnt_ );
        olay.SetAlignment( aln_ );
    }

    iwd = jwd = 0;
    skl_ = sta_ = 0;
    xorg = 0.0;
    while (iwd < nwd_) {
        // Get the begin and end of the current line (in GL coord.).
        xbe = bgf_( cry_ + asc_, dff_ );
        if ((xxx = bgf_( cry_ - dsc_, dff_ )) > xbe) xbe = xxx;
        xen = enf_( cry_ + asc_, dff_ );
        if ((xxx = enf_( cry_ - dsc_, dff_ )) < xen) xen = xxx;

        if (rflg) glTranslatef( xbe - xorg, 0.0, 0.0 ); // Set origine at the begin of line

        rem = xen - xbe;
        olay.SetLineLength( rem );
        bgl_ =  1;                      // We are at the begin of a line.
        jwd = iwd;
        do {
            adw = Wrd_Tab[jwd].adwd_;   // Get the advance of the word, ...
            ipw = Wrd_Tab[jwd].idwd_;   // ... its position in the buffer and ...
            ilw = Wrd_Tab[jwd].lnwd_;   // ... its length in byte(s).

            if (txtbuf[ipw] = '\t') {   // When the first char is a TAB ...
                if (bgl_) {             // We make an "alinea".
                    xbe  += ali_;       // We increase the x begin of the line the TAB width ...
                    rem  -= ali_;       // ... and decrease the line length.
                    bgl_  =    0;       // We clear the
                } else {                // We stop we the line here (and mask the TAB for next).
                    bgl_ = 1;
                    Wrd_Tab[jwd].idwd_++;
                    Wrd_Tab[jwd].lnwd_--;
                    break;
                }
            } else bgl_ = 0;
            if (adw < rem) {            // We can add this word in the line.
                rem -= adw;
                jwd++;
            } else break;               // The line is full.
        } while (1);

        // Here, a Line is completed idw is the index of the first word of line ...
        // ... and jdw .
        //
        ibl = Wrd_Tab[iwd].idwd_;
        iel = Wrd_Tab[jwd-1].idwd_  + Wrd_Tab[jwd-1].lnwd_;

        if (rflg) {
            glTranslatef( xbe - xorg, 0.0, 0.0 );       // Set origine at the begin of line.
            olay.Render( txtbuf + ibl, iel - ibl );     // Output the line of text.
            xorg = xbe;
        }
        cry_ -= htl_;                   // We skip to the next line.
        glTranslatef( 0.0, -htl_, 0.0 );
    }
    if (rflg) glPopMatrix();
    return 1;
} // void Spc_Layout::Work( bool rflg ).



int  Spc_Layout::Measure( const char * txt, GLdouble limy )
{
    if (txt && txt[0]) Text_Parsing( txt );
                  else if (nwd_ < 1) return 0;

    Work( 0 );
    if (limy != 1.0e10 && limy > cry_) return 0;
    return 1;
} // GLdouble Spc_Layout::Height( const char txt ).



int Spc_Layout::Render( const char * txt )
{
    if (txt && txt[0]) Text_Parsing( txt );
                  else if (nwd_ < 1) return 0;
    Work( 1 );
    return 1;
} // GLdouble Spc_Layout::Render( const char txt ).




//
// end of <PW-Id>.
//

