#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/file.h>
//
#define LOCK_SH 1   // shared lock
#define LOCK_EX 2   // exclusive lock
#define LOCK_NB 4   // don't block when locking
#define LOCK_UN 8   // unlock
extern int errno;   // this is located elsewhere
//
void debug(int rc){
    if ((rc>0)||(errno>0)){
    printf("rc: %d err: %d\n", rc, errno);
        errno = 0;  // clear for next time
    }
}
//
void main(){
    FILE *fp;
    int rc;
    //
    printf("fopen\n");
    fp = fopen("lock_demo.dat","wr");
    if (fp == NULL){
        printf("err: %d\n", errno);
    perror("-e-cannot open file");
    exit(2);
    }
    printf("flock\n");
    fprintf( fp, " Coucou je suis là.\n" ); fflush( fp );
    rc = flock( fileno(fp), LOCK_EX|LOCK_NB );
    if (rc) {
        if (errno == EWOULDBLOCK)
            printf( " The file is locked\n" );
        else {
            printf("err: %d\n", errno); perror( "-e-Lock err" );
        }
        exit( 2 );
    }
    debug(rc);
    printf("now run this program on another session\n");
    printf("then hit <enter> to continue");
    getchar();
    printf("\n");
    printf("funlock\n");
    rc = flock( fileno(fp), LOCK_UN );
    debug(rc);
    printf("fclose\n");
    rc = fclose(fp);
    debug(rc);
}
