 //
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


//#define TD_DEBUG


//
// P.Wolfers Software
//

//
// Text Browser module.
//



#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <string.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Native_File_Chooser.H>
#include <FL/Fl_Printer.H>

#include "Text_Browser.h"
#include "Text_Browser_UI.h"



void Text_Browser::Clic_CB( int lng, void *dat )
// The Call back function called when the user clic ...
// on a brower line.
//
{
    if (cbl_) cbl_( lng, owner_ );
} // static void brw_cb( int lng, void *dat ).



Text_Browser * Text_Browser::Init( int w, int h,
                                   const char * lb, const char * tit, void * own )
{
    Text_Browser * myt;

    Text_Browser_UI * tui = new Text_Browser_UI( w, h, lb, tit ); // Create User interface.

    myt  =  tui->w_txt;         // Keep the browser address, ...
    myt->win_   = tui->w_win;   // ... the window address, ...
    myt->tui_   = tui;          // ... the Complete User Interface anc ...
    myt->owner_ = own;          // ... the owner of these objects.
    return myt;
} // Text_Browser * Text_Browser::Init( int w, int h, const char * lb,
  //                                    const char * tit, void * own ).



void Text_Browser::Exit() { tui_->Close(); }



void Text_Browser::resize( int x, int y, int w, int h )
{
    Fl_Hold_Browser::resize( x, y, w, h );
} // void Text_Browser::resize( int x, int y, int w, int h ).



Text_Browser::Text_Browser( int x, int y, int w, int h, const char * l )
                : Fl_Hold_Browser( x, y, w, h, l )
{
    cbl_ = NULL;
    cbx_ = NULL;
    owner_  =         NULL;
    lns_ = NULL;
    textfont( FL_COURIER );
    textsize( 12 );
} // Text_Browser::Text_Browser( int x, int y, int w, int h, const char * l )
  // : Fl_Hold_Browser( x, y, w, h, l ).



Text_Browser::~Text_Browser()
{
    if (cbx_) cbx_( owner_ );
} // Text_Browser::~Text_Browser().



int Text_Browser::SaveFile( const char * path )
{
    int    ie,  ii,  sz  =  size();
    char                   * lgptr;
    FILE * fp = fopen( path, "w" );

    if (fp) {
        for(ii = 1; ii <= sz; ii++) {
            text( ii, lgptr );
            if (lgptr) ie = fprintf( fp, "%s\n", lgptr );
                  else ie = fprintf( fp, "\n" );
            if (ie < 0) {
                fclose( fp );
                return 2;
            }
        }
        fclose( fp );
        return 0;
    } else return 1;
} // int Text_Browser::SaveFile( char * path ).



void Text_Browser::TxtSave()
{
    char *  Text,
         * fpath;

    fpath = fl_file_chooser( "Save File as", "*.txt", "DiaViewer_Rank_Check.txt", 0 );

    if (fpath&&fpath[0]) {
        switch (SaveFile( fpath )) {
            case 1: // Open Error.
                fl_alert( "Error : Cannot create the file %s\n\t error message %s\n", fpath, strerror( errno ) );
                break;
            case 2: // Write Error.
                fl_alert( "Error :Write error to file %s\n\t error message %s\n", fpath, strerror( errno ) );
                break;
            default: ;
        }
    }
} // Text_Browser::TxtSave().








int  Text_Browser::Add( const char * fmt, ... )
{
    va_list ap;
    char buffer[1024];

    va_start( ap, fmt );
    ::vsnprintf( buffer, 1024, fmt, ap );
    va_end( ap );
    add( buffer );
    return size();
} // int  Text_Browser::Add( const char * fmt, ... ).



#ifdef WITH_DEBUG



void MouseCallBack( int bt, int row, int col, void * own )
{
    printf( " Clic with Button %d, at (raw,col) [%d,%d]\n", bt, row, col );
    fflush( stdout );
} // void MouseCallBack( int bt, int row, int col ).



void  ExitCallBack( void * own )
{
    printf( " Exit call back called.\n" );
} // void  ExitCallBack( void * own ).



void  ExitCallBack( void * own )
{
    printf( " Exit call back called.\n" );
} // void  ExitCallBack( void * own ).



int faux_main( int argc, char ** argv )
{
    FILE      * fp;
    char line[256];
    char *     str;

    Text_Browser * DspTxt;

    if ((argc <=1 ) && !argv[1]) {
        fl_alert( " No file was specified => stop" );
        return 1;
    }


    DspTxt = Text_Browser::Init( 800, 500, argv[1], "Text Browser Demontration" );

    DspTxt->SetCallBack( (CallBack_t)MouseCallBack );
    DspTxt->SetCallBackExit( (CallBackExit_t)ExitCallBack );

    if (fp = fl_fopen( argv[1], "r" )) {
        while (str = fgets( line, 255, fp )) {
            printf( " line = %s", line );
            // if (DspTxt->txt_buffer->text()) DspTxt->txt_buffer->text( str );
//          DspTxt->Append( "%s", str );
            DspTxt->add( str );
        }
        fclose( fp );

        Fl::run();

        printf( " Normal End of faux_main.\n" );
    } else  {
        fl_alert( "The File %s cannot be opened", argv[1] );
        return 1;
    }
    return 0;
} // int faux_main( int argc, char ** argv ).



int main( int argc, char ** argv )
{
    int iret = faux_main( argc, argv );

    printf( " Program Normal end with status %d.\n", iret );
    return iret;
}




#endif


//
// end of <PW-Id>.
//
