//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


//#define TD_DEBUG


//
// P.Wolfers Software
//

//
// Environment for Text Browser module.
//


#ifndef TEXT_BROWSER_H
#define TEXT_BROWSER_H

#include <FL/Fl.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/Fl_Double_Window.H>


typedef void (*CallBack_t) ( int nl, void * );
typedef void (*CallBackExit_t) ( void * );

class Text_Browser_UI;

class Text_Browser : public Fl_Hold_Browser {
friend Text_Browser_UI;

private:
    Text_Browser_UI   *   tui_; // Use to keep the address of Text_Display interface.
    Fl_Double_Window  *   win_; // To get access to global text display window.
    CallBack_t            cbl_;
    CallBackExit_t        cbx_;
    char              **  lns_;
    int                   lng_;
    void              * owner_;

    void resize( int x, int y, int w, int h );
    int  SaveFile( const char * );
    void Clic_CB( int, void * );

protected:

    Text_Browser( int, int, int, int, const char * = 0 );
    ~Text_Browser();

public:

    static Text_Browser * Init( int, int, const char *, const char * = NULL, void  * = NULL );

    void SetCallBack( CallBack_t cbl ) { cbl_ = cbl; }

    void SetFont( int, int );

    void Text( char ** txt );

    int  add( const char * txt ) { add( txt ); return size(); }
    int  Add( const char *, ... );
    int  TextPosition();

    void TxtSave();

    void Exit();

};

#endif




//
// end of <PW-Id>.
//

