//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to manage the Slide Context Input/output Files
//
//


#ifndef DIAVIEWER_CTX
#define DIAVIEWER_CTX


#include "DiaViewer_GBL.h"

#define RMAXLEN 2048


// Define the user context file error handler.
typedef         void (*CntxErrCatch_t) ( int ); // Define the Function trap error type.

typedef char                    CntxHeader[16]; // Define the version type context header string.

extern void CntxInsErrCatcher( CntxErrCatch_t );
extern int  CntxInsErrCatcher();

extern int                           CntxHdeIdx; // Current readden file header.


// To Open a Slide context file.
int  CntxOpen( const char * fname, int wrt );   // Open a slide context file.

void CntxClose();                               // Close the opened slide context file.

char * CntxGetText( VarString &vs );            // Get a string from an opened context file.
int  CntxGetInt();                              // Get an integer value from an opened context file.

void CntxPutEoln();                             // Put a line feed.
void CntxPutText( const char * str );           // Put a string to an opened context file.
void CntxPutInt( int val, int fld );            // Put an integer value to an opened context file.


#endif

//
// end of <PW-Id>.
//
