void DiaViewer_GL::ShowSlide( int init )
//
// **** Routine to make visible the Current Slide ****
//
{
  char      mpath[268];
  int   tm, s, f, b, c;

//printf( " Try To load file \"%s/%s\n", Process->CurrPath(), Curr_Sli->FName() );

  if (Curr_Sli) {

//  OutMemsta( "ShowSlide" );
    if (tm = Curr_Sli->FlgTst( Context_MemImg )) {
      if (!SMem) SMem = Curr_Sli;
      W_path->value( "<Internal DiaViewer Memory>" );
      Curr_Map = Curr_Sli->Get( Curr_Sli->FName(), Win_UInb, tm );
    } else {
      snprintf( SliPath, 255, "%s%s", Process->CurrPath(), Curr_Sli->FName() );
      snprintf( mpath, 267, "Path = \"%s\"", SliPath );
      Curr_Map = Curr_Sli->Get( SliPath, Win_UInb, tm );
      W_path->value( mpath );               // Edit the window file reference.
    }

    if (Curr_Map) {   // We have loaded the Slide in the Image Cache.
      i_widt  = Curr_Sli->W();
      i_high  = Curr_Sli->H();
      i_pixs  = Curr_Sli->P();
/*
printf( " * Ori = %c, w = %d, h = %d\n", (i_widt >= i_high)? 'L' : 'P', i_widt, i_high );
fflush( stdout );
*/
      i_shww  = i_hwid = i_widt/2;
      i_shhh  = i_hhig = i_high/2;
      i_cenx  = i_ceny = 0.0;               // Set the default center of display in the image.
      img_x1 = 1 - i_hwid; img_x2 = i_hwid; // Set the image (PixMap) limits.
      img_y1 = 1 - i_hhig; img_y2 = i_hhig;
//    img_x1  =  (img_x2 = i_hwid);         // Set the image (PixMap) limits.
//    img_y1  = -(img_y2 = i_hhig);
      FirstView = 1;

--------------------------------------------------------------

void DiaViewer_GL::draw()
// called to re-draw the GL window.
//
{
  GLint    whwid,        whhig, // Half display size in image pixels.
           map_x,        map_y; // PixelMap origine on Display.
  GLenum                maptyp;
  GLfloat   rx_scale, ry_scale;

  if (Win_Init) Viewer_Init();

#ifndef MESA
  glDrawBuffer(GL_FRONT_AND_BACK);
#endif // !MESA

  if (!valid()) {               // GL Init is done.
    w_widt  =          w(); w_high  =          h();
    w_hwid  =     w_widt/2; w_hhig  =     w_high/2;
    // Set the display pixel origine on the GL Window center in a 3D space.
    // glOrtho( (GLfloat)-w_hwid, (GLfloat)w_hwid, (GLfloat)-whhig, (GLfloat)w_hhig, -20.0, 20.0 );
    valid( 1 );
  }
//printf( " For w # %d, VR %d\n", Win_UInb, ViewReady ); fflush( stdout );

  if (!ViewReady) { // This sequence is executed only during a window_GL creation.
    ViewReady  = 1;
    if (Curr_Vol) InitStdScan( Curr_Vol );
    if (Curr_Sli&&Curr_Dir) ShowSlide( 1 );
    if (Win_UInb == 0) {
      for(int iw = 1; iw < ViewerNbWin; iw++) {
//      printf( " For win %d\n", iw );
        IniSelVolum = (VolEntry*)OpenVolTable.GetObj( WinTable.tab.i[4*iw] );
        SliEntry::CacheSplit( iw );
        Init( iw, 1 );
      }
    }
  }

//printf( " Draw Process\n" ); fflush( stdout );

  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
//printf( "Clear: map %d, mouseSt %d\n", Curr_Map!=0, MouseStat ); fflush( stdout );
  if (Curr_Map) {

//  Already done by ShowSlide().
//  i_shww = i_hwid = (i_widt = Curr_Sli->W())/2;
//  i_shhh = i_hhig = (i_high = Curr_Sli->H())/2;
//  ii_pxs = Curr_Sli->P();

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR Half Window sizes (screen pixels) : %d, %d\n", w_hwid, w_hhig );
      printf( " DR Half image sizes  (image  pixels) : %d, %d\n", i_hwid, i_hhig );
      printf( " DR Image Limits ; x [%d..%d], y [%d..%d]\n", img_x1, img_x2, img_y1, img_y2 );
      fflush( stdout );
    }
#endif

    if (ZoomStatus) {
      // Test validity of the zoom.
      if (i_zcex-i_zshw < i_hwid && i_zcex+i_zshw > -i_hwid &&
          i_zcey-i_zshh < i_hhig && i_zcey+i_zshh > -i_hhig) {
        // Update the center of showed rectangle in image coordinates.

#ifdef GL_DEBUG
        printf( " DR Zoom Half showed sizes (image  pixels) : %d, %d\n", i_zshw, i_zshh );
        printf( " DR Zoom Center of showed zoom (image  pixels) : %d, %d\n", i_zcex, i_zcey );
        fflush( stdout );
#endif

        FirstView = 0;
        if ((GLfloat)w_hwid/i_zshw <= 5.0 || (GLfloat)w_hhig/i_zshh <= 5.0)
        { // Limit the scale at 5.0 (5 Screen_Pixel/Image_Pixel)
          i_cenx = i_zcex; i_ceny = i_zcey;
          i_shww = i_zshw; i_shhh = i_zshh;
        }
      }
      ZoomStatus = 0;
    }

    if (X_shift) {
      i_cenx += X_shift;
      X_shift = 0;
    }

    if (Y_shift) {
      i_ceny +=  Y_shift;
      Y_shift = 0;
    }

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR Half showed sizes (image  pixels) : %d, %d\n", i_shww, i_shhh );
      fflush( stdout );
    }
#endif

    // Compute the display scale (in Display_Pixels/Image_Pixels).
    if (!SetScaVal) {
      rx_scale = (GLfloat)w_hwid/i_shww; ry_scale = (GLfloat)w_hhig/i_shhh;
      r_scale = (rx_scale < ry_scale)? rx_scale : ry_scale;
      if (FirstView&&(r_scale > 1.0)) r_scale = 1.0;
    } else SetScaVal = 0;

    W_zoom->value( r_scale );
    whwid = w_hwid/r_scale; whhig = w_hhig/r_scale;

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR scale = %10.6f\n", r_scale );
      printf( " DR Half Display sizes (Image pixels) : %d, %d\n", whwid, whhig );
      printf( " DR Part of image (%d, %d), Half display Size (%d, %d)\n", i_cenx, i_ceny, whwid, whhig );
      fflush( stdout );
    }
#endif

    // Get the future visible image part rectangle limits.
    cur_x1 = i_cenx -  whwid; cur_y1 = i_ceny -  whhig;
    cur_x2 = i_cenx +  whwid; cur_y2 = i_ceny +  whhig;

    // Compute the pixel and row to skip when required.
    if (img_x1 < cur_x1) { i_spix = cur_x1 - img_x1; map_x = cur_x1; }
                    else { i_spix = 0; map_x = img_x1;}
    i_npix = ((img_x2 > cur_x2)? cur_x2 : img_x2) - map_x;

    if (img_y1 < cur_y1) { i_srow = cur_y1 - img_y1; map_y = cur_y1; }
                    else { i_srow = 0; map_y = img_y1; }
    i_nrow = ((img_y2 > cur_y2)? cur_y2 : img_y2) - map_y;

    W_xscroll->value( i_spix, i_npix, 0, i_widt );
    W_yscroll->value( i_high -i_srow - i_nrow, i_nrow, 0, i_high );

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR *** GL ViewPort : (%d, %d)\n", w_widt, w_high );
      printf( " DR *** Image space Rectangle : %d, %d, %d, %d\n", cur_x1, cur_y1, cur_x2, cur_y2 );
      printf( " DR *** Scale = %8.5f, MapSizes = (%d, %d)\n", r_scale, i_npix, i_nrow );
      printf( " DR *** Skip Pixels,Rows (%d, %d), MapOrg. = (%d, %d)\n", i_spix, i_srow, map_x, map_y );
      fflush( stdout );
    }
#endif

    // Define the showed image space.
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glViewport( 0, 0, w_widt, w_high);  // Set the GL ViewPort.
    glOrtho( (GLfloat)cur_x1, (GLfloat)cur_x2,
             (GLfloat)cur_y1, (GLfloat)cur_y2,
                        -1.0,             1.0
           );
    glEnable( GL_DEPTH );
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

//  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

#ifdef GL_DEBUG
  printf( " DR draw() U %d\n", i_pixs ); fflush( stdout );
#endif

    switch (i_pixs) {
      case 1: maptyp = GL_LUMINANCE; break;
      case 3: maptyp =       GL_RGB; break;
      case 4: maptyp =      GL_RGBA; break;

    default:
      fl_alert( "DiaViewer: Bad type of imag: %d byte/pixel.", i_pixs );
      maptyp = -1;
      printf( " Bad type of image\n" ); fflush( stdout );
//    exit( 2 );
    }

#ifdef GL_DEBUG
  printf( " draw() V %d\n", maptyp ); fflush( stdout );
#endif

    if (maptyp>0) {

#ifdef GL_DEBUG
    printf( "-----> i_widt=%d, i_spix=%d, i_srow=%d, at (%d,%d)\n", i_widt,i_spix,i_srow, map_x, map_y);
//  fflush( stdout );
#endif
      glPixelStorei( GL_UNPACK_ROW_LENGTH,  i_widt );
      glPixelStorei( GL_UNPACK_SKIP_PIXELS,  i_spix );
      glPixelStorei( GL_UNPACK_SKIP_ROWS,    i_srow );
      glPixelStorei( GL_UNPACK_ALIGNMENT,        1 );
      glRasterPos3f( map_x+0.0001, map_y+0.0001, 0.0 );
//    GLboolean valid; glGetBooleanv( GL_CURRENT_RASTER_POSITION_VALID, &valid );
//    printf( " PIxmap Position valid = %d\n", valid );
      glPixelZoom( r_scale, r_scale );
      glDrawPixels(  i_npix, i_nrow, maptyp, GL_UNSIGNED_BYTE, (GLvoid*)Curr_Map );
    }

#ifdef GL_DEBUG
  printf( " DR draw() W\n" ); fflush( stdout );
#endif
    if (MouseStat) {
      glLineWidth( 2.0 );
      glColor3f( 0.5, 0.5, 0.5 );
      glBegin( GL_LINE_LOOP );
      glVertex3f( zre_x1, zre_y1, -1.0 );
      glVertex3f( zre_x2, zre_y1, -1.0 );
      glVertex3f( zre_x2, zre_y2, -1.0 );
      glVertex3f( zre_x1, zre_y2, -1.0 );
      glEnd();
    }
  }

#ifdef GL_DEBUG
  printf( " DR draw() X\n" ); fflush( stdout );
#endif

#ifndef MESA
  glDrawBuffer(GL_BACK);
#endif // !MESA

//printf( " Draw Process End\n" ); fflush( stdout );
} // void DiaViewer_GL::draw().


///
