//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

#ifndef DIAVIEWER_GLH
#define DIAVIEWER_GLH 1


#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>
#include <FL/fl_message.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Gl_Window.H>
#include <FL/Fl_Printer.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Native_File_Chooser.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Spinner.H>
#include <FL/Fl_Text_Editor.H>
#include <FL/fl_draw.H>

#include <FL/gl.h>
#include <GL/glu.h>

#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <math.h>



#ifndef  SCREEN_ID
# define SCREEN_ID 0
#endif

// Must be included to get the Vo, Dir and SliEntry definition.

#include "DiaViewer_SUP.h"
#include "DiaViewer_DIA.h"
#include "DiaViewer_PRG.h"



const int screen_nb= SCREEN_ID; // Used Screen number (For us, Always 0).


// General simple function to init the windowing system.
void    DiaWiewer_GL_Init( int, char **, int );



class DiaViewer_GL : public Fl_Gl_Window {
    
private:
    int         Win_Init  =  1, // Flag to init at the first call of draw().
                Win_UInb  =  0, // Index of UI in the Viewer_UI table.
                Win_ScDi  =  0; // Scan direction is keep here.

    int     slinb_,     flmnb_, // Copy of value to compare ...
            parnb_,     chpnb_, // ... with the original value.
                        profl_; // Flag for slide protection.


    //User Interface access definitions:

    Fl_Double_Window *   W_main; // Access pointers to FLTK related window, ...

    Fl_Button        *   W_fdir, // ... to first directory, ...
                     *   W_pdir, // ... to previous directory, ...
                     *   W_fsli, // ... to first slide in the directory, ...
                     *   W_psli; // ... to previous slide, ...
    Fl_Slider        *   W_zoom; // ... to previous slide, ...
    Fl_Button        *   W_nsli, // ... to next slide, ...
                     *   W_lsli, // ... to last slide, ...
                     *   W_ndir, // ... to next directory, ...
                     *   W_ldir; // ... and to last directory.
                      
    Fl_Scrollbar     *W_xscroll, // Pointer to the slider of width ...
                     *W_yscroll; // ... and hight.

    Fl_Button        *  W_Class; // Pointer to classement button, ...
    Fl_Output        *   W_Path; // ... the slide path output, and the ...
    Fl_Text_Editor   *   W_Text; // ... comment text editor/multilign output.
    
    Fl_Button        *   W_iden, // Return to original orientation, ...
                     *   W_rp90, // ... rotation +90°, ...
                     *   W_rm90, // ... -90°, (clock wise) ...
                     *   W_r180, // ... 180°, ...
                     *   W_invx, // ... x <-> -x, and ...
                     *   W_invy, // ... y <-> -y.
                     *   W_invu, // ... x <-> -y.
                     *   W_invv; // ... x <-> -y.

    Fl_Spinner       *  W_sliid, // Display/Edit slide #,
                     *  W_flmid, // Display/Edit film #,
                     *  W_parid, // Display/Edit paragraph #,
                     *  W_chpid; // Display/Edit Chapter #.
    Fl_Check_Button  *   W_lock; // To can change the lock botton flag.
    Fl_Light_Button  *  W_autom; // To can change the Auto Mode botton flag.
    Fl_Output        *  W_title; // Display Dir/Vol title.

    Fl_Text_Buffer   * Lab_Text; // The text buffer is not in DiaViewer_UI class.

    Fl_Group         * W_orient; // Pointer to the orientation button group.

    char           SliPath[256]; // The current slide path.


public:

    // This values determines the scaling factor used to draw the cube.

    GLint       w_widt, w_high, // Width and High of GL Window Image space in pixels.
                w_hwid, w_hhig, // Half GL Window sizes (Screen pixels).
                i_widt, i_high, // Width and high of the image in image pixels.
                i_hwid, i_hhig, // Half sizes of image.
                i_shww, i_shhh, // Showed half zoom rectangle sizes (Image pixels).
                i_cenx, i_ceny, // Current center of showed rectangle.
                i_zshw, i_zshh, // New zoom rectangle (Image pixels).
                i_zcex, i_zcey, // Zoom rectangle center coordinates (Image pixels).
                img_x1, img_y1, // The limits of the current image.
                img_x2, img_y2, //
                cur_x1, cur_y1, // Current limits of the displayed image.
                cur_x2, cur_y2,
                zre_x1, zre_y1, // Mouse Zoom rectangle window pîxel coordinates. 
                zre_x2, zre_y2,
                i_npix, i_nrow, // Visible Part of image.
                i_spix, i_srow, // Skipped(left/low) part of the image.
                
                i_pixs;         // Size of a pixel(1=luminance, 3=RGB, 4=RGBA).

    GLint       ViewReady  = 0, // OpenGL window Init Flag.
                UsedButton,     // memory for mouse button use.
                MouseStat  = 0, // Used button for Zoom ans Mouse status.
                ZoomStatus = 0, // Status to flag a zoom/sceolling request.
                FirstView  = 0, // Signal original view setup when set to one. 
                SetScaVal  = 0, // Flag to force a specified scale.
                X_shift    = 0, // Shift (for scrollbar along x or y.
                Y_shift    = 0;
/*
    GLfloat     ZRec_X, ZRec_Y,
                ZRec_W, ZRec_H, // Zomm rectangle sizes (in window pixels).
                ZCen_X, ZCen_Y; // Zoom central coordinates (in window pixels).
*/
    GLfloat     r_scale;        // Scale in Screen-Pixel/Slide-Pixel.


    GLubyte         * Curr_Map; // The map of the current slide.

    int            ViewerReady, // Viewer Init flag.
                   ViewRkgEdit, // Flag to Enable/Disable the classement edition.
                   ViewRkgAuto, // Flag to Enable/disable slide auto classement mode.
                   ViewRkgTitl; // Flag for select Volume or directory name display.

    SliEntry        * Curr_Sli; // Pointer to the Current Slide.
    DirEntry        * Curr_Dir; // Pointer to the Current Directory.
    VolEntry        * Curr_Vol; // Pointer to the current Volume.
    
    SlidePrg        *  Program; // Slide Program to execute. 
    SlideExec       *  Process; // Slide processor pointer.
    

    DiaViewer_GL( int, int, int, int, const char *title=0 );
    
    void Viewer_Init();         // To initialize the specialized pointers.
    void New_View();            // To create a new slide view.

    void Tranf( int it );       // To manage the slide transformations.
    void ShowSlide( int );      // To display a slide.
    void NormalEnd( int );      // To end a DiaViewer session.
    void SetSize( int, int );   // Force the size (arguments in Gl space).
    void DiaSearch();           // To search and locate a particular slide.

    void DiaSetup();            // Open and close the setup Window.
    void DiaVersion();          // Open and close the "Window Software informations"..

    void VolClose();            // Close a SlideVolume.
    int  CloseAllVol();         // Close all Slide Volume.
    void VolOpen( int );        // To Open a new slide volume and set the first slide.
    void VolSelect();           // To change of slide volume.
    void VolCreate();           // To create a new (and empty slide volume.

    void InitStdScan( VolEntry* ); // To initialize and start a manual volume scan.
    
    void SliScan( int );        // To scan a slide directory.
    void DirRestart( int );     // To restart the slide scan from the begin or end of volume.
    void DirScan( int );        // To scan between of directories.
    void SliTransf( Image_REF::Image_Trf );     // Rotation and mirrors transformation of the current slide.
    void SliPrint();            // To print the current slide.

    void ChkSliCntxFlags();     // To Set the flags for context change.
    void EditText();            // To manage Slide Textes changes.
    void EditNumbers( int );    // To manage Slide numbers/flags changes.

    void XScroll();             // Scrolling bars CallBack routine.
    void YScroll();
    void SetScale( float );     // CallBack routine to change the image scale (Zoom slider).
    void UnZoom( int );         // To manage the mouse zoom.
    void Classify();            // To open the classification/Ranking pannel.

    void ProtectCntx();         // Save the current slide context.

    void DefSetBlkNbr( int );   // To reset To one low weight block and slides numbers.
    void DefSetSliNbr();        // Back Call on init change of slide number.

    void SetDirTitle();         // To display the name/text of current directory/folder.
    void SetVolTitle();         // To display the name/text of volume.

    int  RkgEditEnDi();         // Return 1/0 when unlocked/locked the CLM/RKG modifications.
    void RkgTitleVolDir();      // To Display Directory/Folder0) or Volume name(1).

    void RkgClearCntx();        // Clear context data.
    void RkgCntxClear( int );   // To Clear CLM/RKG slide context (0) or Directory context (1).
    void RkgCntxZero();         // Clear all Ranking numbers and set it as write protected.
    void RkgCntxProtect( int, int ); // Modify Context protections.
    void SaveContext();         // Save the data context for the selected volume.

private:
    
    void CheckEditText();       // To check when the slide anotation modified.
    void CheckEditNumbers();    // To check when the slide parameters modified.

    void ActiveProtect();       // active/deactive protection in widget dialogue.

    void XYinImage( int &x, int &y );
    void MouseDown( int, int, int );
    void MouseDrag( int, int, int );
    void MouseUp( int, int, int );

    int  LflTst( int fl ) { return profl_ & fl; }
    void LflSet( int fl ) { profl_ |= fl; }
    void LflClr( int fl ) { profl_ &= ~fl; }

protected:

    int  handle( int );
    /* */
    void draw();
  
  
};



#endif


extern DiaViewer_GL  * ViewToPrint;


//
// end of <PW-Id>.
//
