//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer GL GL multiview display services environment.
//
//


#ifndef DIAVIEWER_MVIH
#define DIAVIEWER_MVIH 1


#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>
#include <FL/fl_message.H>
#include <FL/Fl_Text_Editor.H>


#include "DiaViewer_DIA.h"



// #define GL_DEBUG






class SliRefer {

private:
    SliRefer          * vnext_; // Pointer to next free reference block.
    SliEntry          * vslid_; // Pointer to the shown slide.
    Image_MAP         * vmapp_; // Pointer to slide cache.
    Fl_Text_Buffer    * vtxbf_; // Operational Text buffer for slide comment.
    UInt16     vslii_,  vflmi_, // Operational Copies of Slide Ranking numbers.
               vchpi_,  vnote_,
                        vflag_; // Operational Copy of slide flags.
    UChar               vcoun_; // Item reference count.
    SChar               vwidx_; // The first index in ViewTab[].

    SliRefer();                 // Creator Used by Init (don't use directly).
    
    void   CheckTextEdit();                     // Check for comment text change(s).
//  void   CheckUsidEdit();                     // Check for User Ident.
    void   CheckNumbersEdit();                  // Check for Ranking numbers and flags protection change.

public:
    static void Init( int );                    // To initialze the reference system.

    void RefFree( int );                        // To free a window reference.
    static SliRefer* RefLink(SliEntry *, int);  // To create a window reference of a slide.

    int  FirstWin() { return vwidx_; }  // Return First Window Index.

    Fl_Text_Buffer * BfText() { return vtxbf_; }
    int    Numb()   { return vslii_; }
    int    Film()   { return vflmi_; }
    int    Chap()   { return vchpi_; }
    int    Note()   { return vnote_; }
    int    FlgVal() { return vflag_; }
    int    FlgTst( int f ) { return vflag_ & f; }
    int    FlgTvl( int f ) { return vflag_ & ~f; }
    int    WinOwner() { return vwidx_; }
  
    void   Numb( int v )   { vslii_ = v; }
    void   Film( int v )   { vflmi_ = v; }
    void   Chap( int v )   { vchpi_ = v; }
    void   Note( int v )   { vnote_ = v; }
    void   FlgVal( int v ) { vflag_ = v; }
    void   FlgSet( int f ) { vflag_ |= f; }
    void   FlgClr( int f ) { vflag_ &= ~f; }

    void   RefRkgClr() { vslii_ = vflmi_ = vchpi_ = vnote_ = 0; }
    void   RefRkgGet( SliEntry * );     // Get Numbers from Slide Descriptor to Reference Block.
    void   RefRkgSet( SliEntry * );     // Set Numbers from Reference Block to Slide Descriptor.
    void   RefRkgGet( int &s, int &f, int &c, int &n ) { s = vslii_; f = vflmi_; c = vchpi_; n = vnote_; }
    void   RefRkgSet( int s, int f, int c, int n ) { vslii_ = s; vflmi_ = f; vchpi_ = c; vnote_ = n; }
    int    RefRkgTst() { return (vslii_&&vflmi_&&vchpi_&&vnote_&&FlgTst( Context_Protect )); }
    int    RefRkgTZero() { return !(vslii_||vflmi_||vchpi_||vnote_||FlgTst( Context_ProInb )); }

    static SliRefer * LookMultipl( SliEntry *, int );   // To set or change a window slide reference with ...
                                                        // ... management of multiple reference to the same slide.

    void   CheckSliCntx();                              // Check for all Context change.

    void   RefRkgUpdDisp( int, int, int, int );         // To update Display of Ranking numbers.

//  void   RefOriUpdDisp();                             // To update all Displays of a modified slide.
    
};





#endif

//
// end of <PW-Id>.
//
