kwrite//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Module to Print a Slide.
//

#include <stdio.h>
#include <string.h>

#include "Service_PrImg.h"

#include "DiaViewer_GL.h"
#include "DiaViewer_Print.h"




Fl_Image * DiaView_Printer::BuildImage( Image_REF * src, int xx, int yy, int ww, int hh )
{
  int       src_rsz,   dst_rsz,
            src_wid,   src_hig,
            dst_siz,  ira, ipc,
                            pp;

  uchar   * src_cra, * src_cco,
          * dst_cra, * dst_cco;
  uchar   * src_map, * dst_map; // Define the source and destination pixel map pointers.

  Fl_RGB_Image         * flimg;


  pp            =     src->P(); // Get the pixel size and raw alignement mask.
  src_wid       =     src->W(); // Get the original width (in pixels) of image.
  src_hig       =     src->H(); // Get the original hight (in pixels) of image.
  src_map       =   src->Map(); // Get the source (src) image pixel map.

  if (!src_map) return 0;

  if (ww > src_wid) ww = src_wid;
  if (xx < 0) xx = 0;
  else if (xx + ww > src_wid) xx = src_wid - ww;

  if (hh > src_hig) hh = src_hig;
  if (yy < 0) yy = 0;
  else if (yy + hh > src_hig) yy = src_hig - hh;

  src_rsz       =   pp*src_wid; // Get the original size (in byte) of image raws.
  dst_rsz       =        pp*ww; // Get the size (in byte) of final pixel map raws.
  dst_siz       =   dst_rsz*hh; // Get the final pixel map image size.

  dst_map = new GLubyte[dst_siz];       // Allocate the print map and ...

  src_cra = src_map + yy*src_rsz+xx*pp; // Set the src current raw -> first pixel of the src image (first dst pixel) (at image bottom).
  dst_cra = dst_map + dst_siz;          // dst_raw -> first not existing dst pixel map raw (below the bottom image).
  for(ira = 0; ira < hh; ira++) {
    dst_cra -= dst_rsz;                 // dst_cra -> first pixel of src current raw (starting from bottom raw).
    dst_cco  = dst_cra;                 // dst_cco = dst_cra to init the dst raw filling.
    src_cco  = src_cra;                 // src_cco -> first byte to copy in the destination.
    for(ipc = 0; ipc < dst_rsz; ipc++)  // Loop to fill all pixels (dst_rsz bytes) of the raw.
      *(dst_cco++) = *(src_cco++);
    src_cra += src_rsz;                 // src_cra -> first pixel of dst for next raw (starting from the top raw).
  }

  flimg = new Fl_RGB_Image( dst_map, ww, hh, pp, dst_rsz );
  flimg->alloc_array = 1;

  return flimg;
} // Fl_Image * DiaView_Printer::BuildImage( Image_REF * src, int xx, int yy, int ww, int hh ).



void DiaView_Printer::Print_Widget( Fl_Widget * w )
{
    Smp_Printer::Print_Widget( w );
} // void DiaView_Printer::Print_Widget( Fl_Widget * w ).




void DiaView_Printer::Print_Slide( DiaViewer_GL * wgl, int imx, int imy, int imw, int imh )
{
    int   ii,  jj,  kk;
    char         * txt;
    char            ch;
    char     btx[1024];
    char       tit[64];
    const char  * vnam;
    SliEntry     * sli;
    Fl_Image     * img;
    Smp_Printer  * lpt;

    sli = wgl->Curr_Sli;
    vnam = wgl->Curr_Vol->VName();

    img = BuildImage( sli, imx, imy, imw, imh );

    if (!img) return;

    lpt = new Smp_Printer();
    if (PrtFlgTst( PrintGL_Text )) {                    // When the slide text commeny is required ...
        txt = sli->Text();                              // ... get it.
        ii = jj = 0;
        if (txt && txt[0]) {                            // If this text is not a null text and ...
            if (txt[0] == '*' && txt[1] == '[') {       // ... if its begin is an original slide ident ...
                ii += 2;
                while ((ch = txt[ii++]) && ch != ']')   // Loop to find the end of old ref.
                    btx[jj++] = ch;
                if (ch =='.') ii++;
                btx[jj++] = ':'; btx[jj++] = ':';       // "*[rrrr]" is replace by rrrr::
            }
            while ((ch = txt[ii]) && ch <= ' ') ii++;   // Skip any space character.
            if (jj && ch) btx[jj++] = ' ';              // Set a space between the Ori. ref. and the slide text.
            kk = jj;
            do btx[jj++] = ch = txt[ii++]; while (ch);

            lpt->Set_Text_Pos( Smp_Printer::Smp_Default ); // Set the position.
            if (PrtFlgTst( PrintGL_OIdent )) lpt->Set_Text( btx + kk );
                                        else lpt->Set_Text( btx );
        } else lpt->Set_Text( 0 );
    }  else lpt->Set_Text( 0 );


    if (PrtFlgTst( PrintGL_Ident )) {                   // When the slide text commeny is required ...
        snprintf( tit, 63, "%s Id = %d/%d/%d", vnam, sli->Chap(), sli->Film(), sli->Numb() );
        lpt->Set_Title( tit );
    } else lpt->Set_Title( 0 );

    lpt->Print_VueImage( img );

    delete lpt;
} // void DiaView_Printer::Print_Slide( SliEntry * sli, int ).



//
// end of <PW-Id>.
//
