//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Module to Print a Slide environment.
//


#ifndef DIAVIEWER_PRINT
#define DIAVIEWER_PRINT

#include "DiaViewer_GBL.h"
#include "DiaViewer_DIA.h"
#include "Service_PrImg.h"



class DiaView_Printer : public Smp_Printer {
private:
    Smp_Printer * printer;

    Fl_Image * BuildImage( Image_REF *, int, int, int, int );

public:
    DiaView_Printer( const char * L = 0 ) : Smp_Printer( L ) { printer = 0; }

    void PrtFlgSet( int fl ) { PrintFlags |= fl; }
    void PrtFlgClr( int fl ) { PrintFlags &= ~fl; }
    int  PrtFlgTst( int fl ) { return PrintFlags & fl; }

    void Print_Widget( Fl_Widget * w ); // { Smp_Printer::Print_Widget( w ); }
    void Print_Slide( DiaViewer_GL *, int, int, int, int );

};

#endif


//
// end of <PW-Id>.
//
