//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Ranking Context module.
// Manage an operational stack for automatic creation of ...
// ... directories of a slide collection (volume) tree.
//

#include <setjmp.h>

#include "DiaViewer_RCT.h"
#include "DiaViewer_CTX.h"

#if (defined(WIN32) && !defined(__CYGWIN__)) || defined(__EMX__)
# define sigjmp_buf jmp_buf
# define sigsetjmp( a, b ) setjmp( a )
# define siglongjmp longjmp
#endif

extern char         * tvol_nam; // To get the volume name.

static
  DirRefer  * RefStack  = NULL; // Top of directory reference stack list.

static sigjmp_buf       JmpBuf; // Buffer for long jump on I/O context error.


DirRefer::DirRefer( DirRefer * old )
{
    rfd_own_     =         old; // Save the top of directory reference stack, ...
    rfd_frs_ = rfd_lst_ = NULL; // ... initialize the slide reference list header ...
    rfd_nsl_     =           0; // ... and its size (in slide reference).
    RefStack     =        this;
} // DirRefer::DirRefer().



DirRefer * DirRefer::DelRef( DirRefer * rdi )
{
    SliRefer * rsl;

    if (rdi) {
        RefStack = rdi->rfd_own_;
        while (rfd_frs_) {
            rsl       =       rfd_frs_; // Get the current slide reference.
            rfd_frs_  =  rsl->rfs_nxt_; // keep its next one.
            rsl->rfs_sli_   =     NULL;
            delete[] rsl->rfs_nam_;
            delete rsl;
        }     
        delete rdi;
    }  else RefStack = NULL;
    return RefStack;
} // DirRefer * DirRefer::DelRef( DirRefer * rdi ).



void DirRefer::AddSliRef( const char * name, SliEntry * sli )
{
    SliRefer * rsl = new SliRefer;

    rsl->rfs_nxt_ = NULL;
    if (rfd_frs_) rfd_lst_ = (rfd_lst_->rfs_nxt_ = rsl);
             else rfd_frs_ = rfd_lst_ = rsl;
    rfd_nsl_++;
    rsl->rfs_nam_ = strdup( name );
    rsl->rfs_sli_ = sli;    
} // void DirRefer::AddSliRef( const char * name, SliEntry * sli ).



static void ErrorCatch( int err )
{
    siglongjmp( JmpBuf, err );
} // void ErrorCatch( int ierr ).



void DirRefer::WriteDirCntxFile( int deep, const char * fpath )
// Special procedure to create the directories ranking context ...
// ... of the new sorted slide collecetion (or volume).
//
{
    DirRefer::SliRefer * rsl;
    SliEntry           * sli;

    CntxInsErrCatcher( ErrorCatch );
    if (CntxOpen( fpath, 1 ) > 0) { // Open to write Success.
        if (!sigsetjmp( JmpBuf, 1 )) {
            if (!rfd_own_) { // We create the context file of the new root volume.
                CntxPutInt( 0, 2 );             // Deep of 0 for the volume.
                CntxPutEoln();
                CntxPutInt( Context_RkgEna, 6 );// Volume flags.
                CntxPutText( tvol_nam );        // Volume VName.
                CntxPutInt( 0, 6 );             // Initial value for Volume PrgPc and
                CntxPutInt( 0, 6 );
                /* /// ???
                CntxPutText( dirfrm ); CntxPutText( fold_hde );
                CntxPutText( slifrm );
                */
            } else CntxPutInt( deep, 2 );       // For none root directory put the dir deep.
            CntxPutEoln();
            // Create the current directory context data.
            CntxPutInt( 0, 6 );                 // Put Directory flags.
///         CntxPutInt( deep, 4 );
            CntxPutText( NULL );                // Put Directory text.
            // Create the context data for each slide in this new slides directory.
            rsl = rfd_frs_;
            while (rsl) {
                CntxPutText( rsl->rfs_nam_ );
                sli = rsl->rfs_sli_;
                CntxPutInt( sli->FlgVal() & ~Context_Update, 6 );
                CntxPutInt( sli->CurOpe(), 2  );
                CntxPutInt( sli->Numb(), 6 ); CntxPutInt( sli->Film(), 6 );
                CntxPutInt( sli->Para(), 4 ); CntxPutInt( sli->Chap(), 4 );
                CntxPutText( sli->Text() );
                rsl = rsl->rfs_nxt_;
            }
        }
        CntxClose();
    }
    CntxInsErrCatcher();
} // void DirRefer::WriteDirCntxFile( int deep ).





//
// end of <PW-Id>.
//
