//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Environment of DiaViewer Slide Volume List ManaGment..
//


#ifndef DIAVIEWER_VRFL_H
#define DIAVIEWER_VRFL_H


#include "Service_IO.h"
#include "Service_Util.h"

#include "DiaViewer_DIA.h"





class VolRefList : public SrvFile {
private:
    int           upd_, // Flag to indicate a file update to perform.
                  osz_; // Old size of volume list.
    const char  * pat_; // Path of file to use.
    ObjTable      ols_;
    VolRef     ** svl_; // Pointer to a sorted volume list.

    int GetFreeIde();

public:
    VolRefList( const char * = NULL );

    void FileSet( const char * path ) { pat_ = path; }

    int       ListSize() { return ols_.TabUse(); }
    VolRef ** RefList() { return (VolRef**)ols_.GetObjs( 0 ); }
    VolRef  * IdxVolRef( int idx ) { return (VolRef*)(ols_.GetObj( idx )); }

//  static VolRefList * Init( const char * pa ) { upd_ = 0; }
//  void Set( const char * pa = NULL ) { VolRefList( pa ); }

    void Select( const char * path ) { pat_ =  path; }

    int  Read( const char * = NULL );   // Read/Write/Update the File copy of ...
    int  Write( const char * = NULL );  // ... all known volumes definitions.

    int       GetSize() { return ols_.TabUse(); }
    VolRef ** GetRefs() { return (VolRef**)ols_.GetObjs( 0 ); }

    VolRef * Append( const char * = NULL, const char * = NULL, int = 0 );
    VolRef * Insert( const char * = NULL, const char * = NULL );
    VolRef * Locate( int );
    VolRef * Locate( const char * );
    void     Remove( VolRef * & );

    // This next routine must be used just before the call of Appoend or Insert ...
    // ... to create the VolRef. This function does not free the &name argument ...
    // ... if it is an dynamically allocated by new/malloc operators.
    int  NewReferEl( const char *, char * & );

    const char * DefName();

    int  CheckPath( const char * );
    void MakeUnique( char * vname, int all );
    int  CheckName( const char * );
    int  CheckAllNames();

    VolRef ** SortVList( int &, int &, int &,  VolMnf_t );

};




#endif


//
// end of <PW-Id>.
//
