//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Environnement fto generatea specific FLTK Spinner Widget.
// P.Wolfers
//



#include <stdio.h>
#include <stdlib.h>

#include "FlW_Spinner.h"


void FlW_Spinner::sb_cb(  Fl_Widget * w, FlW_Spinner * sb )
{
    double v;

    if (w == &(sb->input_)) {
        v = atof( sb->input_.value());
        if (v < sb->minimum_) {
            sb->value_ = sb->minimum_;
        } else if (v > sb->maximum_) {
            sb->value_ = sb->maximum_;
        } else sb->value_ = v;
    } else if (w == &(sb->up_button_)) {
        v = sb->value_ + sb->step_;
        if (v > sb->maximum_) sb->value_ = (sb->wrap_)? sb->minimum_ : sb->maximum_;
                         else sb->value_ = v;
    } else if (w == &(sb->down_button_)) {
        v = sb->value_ - sb->step_;
        if (v < sb->minimum_) sb->value_ = (sb->wrap_)? sb->maximum_ : sb->minimum_;
                         else sb->value_ = v;
    }
    sb->update();
    sb->set_changed();
    sb->do_callback();
} // void FlW_Spinner::sb_cb(  Fl_Widget *w, FlW_Spinner *sb ).



void FlW_Spinner::update()
{
    char s[255];

    if ((format_[0] == '%')&&(format_[1] == '.') && (format_[2] == '*')) {
        // Precision argument.
        // This code block is a simplified version of ...
        // ... Fl_Valuator::format() and works well (but looks ugly).
        int c = 0;
        char temp[64], * sp = temp;

        sprintf( temp, "%.12f", step_ );
        while (*sp) sp++; sp--;
        while ((sp > temp) && (*sp == '0')) sp--;
        while ((sp > temp) && (*sp >= '0') && (*sp <= '9')) { sp--; c++; }
        sprintf( s, format_, c, value_ );
    } else sprintf( s, format_, value_ );
    input_.value( s );
} // void FlW_Spinner::update().




#define FL_UP_ARROW_TX "@-42<"
#define FL_DOWN_ARROW_TX "@-42>"

FlW_Spinner::FlW_Spinner( int X, int Y, int W, int H, const char * L ) :
                        Fl_Group( X, Y, W, H, L ),
                        input_( X,                     Y, W - H/2 - 2,   H ),
                        up_button_( X + W - H/2 - 2,       Y,     H/2 + 2, H/2, FL_UP_ARROW_TX ),
                        down_button_( X + W - H/2 - 2, Y + H/2,     H/2 + 2, H/2, FL_DOWN_ARROW_TX )
{
    end();

    value_    =    1.0;
    step_     =    1.0;
    minimum_  =    1.0;
    maximum_  =  100.0;
    wrap_     =      1;
    format_   =   "%g";

    outcolor_ = FL_RED;
    actcolor_ = FL_FOREGROUND_COLOR;

    align( FL_ALIGN_LEFT );
  
    input_.value( "0" );
    input_.type( FL_INT_INPUT );
    input_.when( FL_WHEN_ENTER_KEY | FL_WHEN_RELEASE );
    input_.textcolor( actcolor_ );

    input_.callback( (Fl_Callback *)sb_cb, this );
    up_button_.callback( (Fl_Callback *)sb_cb, this );
    down_button_.callback( (Fl_Callback *)sb_cb, this );

    clear_output();

} // FlW_Spinner::FlW_Spinner( int X, int Y, int W, int H, const char * L ).



int  FlW_Spinner::handle( int event )
{
    switch (event) {
        case FL_KEYDOWN :
        case FL_SHORTCUT :
            if (Fl::event_key() == FL_Up) {
                up_button_.do_callback();
                return 1;
            } else if (Fl::event_key() == FL_Down) {
                down_button_.do_callback();
                return 1;
            } else return 0;

        case FL_FOCUS :
            if (input_.take_focus()) return 1;
                                else return 0;
    }
    return Fl_Group::handle(event);
} //int  FlW_Spinner::handle( int event ).



void FlW_Spinner::resize( int X, int Y, int W, int H )
{
    Fl_Group::resize( X, Y, W, H );
    input_.resize(              X,        Y, W - H/2 - 2,   H );
    up_button_.resize( X + W - H/2 - 2,       Y,     H/2 + 2, H/2 );
    down_button_.resize( X + W - H/2 - 2, Y + H/2,     H/2 + 2, H/2 );
} // void FlW_Spinner::resize( int X, int Y, int W, int H ).



void FlW_Spinner::step( double s )
{
    step_ = s;
    if (step_ != (int)step_) input_.type(FL_FLOAT_INPUT);
                        else input_.type(FL_INT_INPUT);
    update();
} // void FlW_Spinner::step( double f ).



/**
  Handles events of Fl_Spinner's embedded input widget.

  Works like Fl_Input::handle() but ignores FL_Up and FL_Down keys
  so they can be handled by the parent widget (Fl_Spinner).
*/
int FlW_Spinner::FlW_Spinner_Input::handle( int event ) {
  if (event == FL_KEYBOARD) {
    const int key = Fl::event_key();
    if (key == FL_Up || key == FL_Down) {
      Fl_Input::handle( FL_UNFOCUS ); // sets and potentially clips the input value
      return 0;
    }
  }
  return Fl_Input::handle(event);
}




void FlW_Spinner::type(uchar v) {
    if (v==FL_FLOAT_INPUT) format("%.*f"); else format("%.0f");
    input_.type(v);
} // void FlW_Spinner::type(uchar v).



void FlW_Spinner::set_output()
{
//printf( "   Set_Out : actcol %d, outcol %d, color %d\n", actcolor_, outcolor_, input_.color() );
    FlW_Spinner::up_button_.deactivate();
    FlW_Spinner::down_button_.deactivate();
    FlW_Spinner::input_.set_output();
    FlW_Spinner::input_.textcolor( outcolor_ );
} // void FlW_Spinner::set_output().



void FlW_Spinner::clear_output()
{
//printf( " Clear_Out : col %d, outcol %d, color %d \n", actcolor_, outcolor_, input_.textcolor() );
    FlW_Spinner::up_button_.activate();
    FlW_Spinner::down_button_.activate();
    FlW_Spinner::input_.clear_output();
    FlW_Spinner::input_.textcolor( actcolor_ );
} // void FlW_Spinner::clear_output().



//
// end of <PW-Id>.
//
