//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to manage the Image file for OpenGL.
//



// Define the size of the photographies (or Slides) cache table.

#ifndef IMAGEMAN_REF
#define IMAGEMAN_REF


#include <GL/gl.h>              // To use the GL intgere and float types.

#include <FL/fl_utf8.h>

#include "ImageMan_MAP.h"       // Load Image Map definitions.


//
// The Size of cache should be a power of 2,
//
#ifndef DEFAULT_CACHE_SIZE
#   define  DEFAULT_CACHE_SIZE 64
#endif


#ifndef DIRSEP
#   if defined(WIN32) || defined(__EMX__) && !defined(__CYGWIN__)
#       define DIRSEP '\\'
#   else
#       define DIRSEP '/'
#   endif
#endif




////
//// The Deep of cache (to allow to have several Image with
//// the same IIde & CACHE_MASK intersection.
////
////#ifndef DEFAULT_CACHE_MULTI
////#   define  DEFAULT_CACHE_DEEP 2
////#endif
////


typedef unsigned short UInt16;
typedef unsigned int   UInt32;
typedef unsigned char   UChar;



class Image_REF {
friend Image_MAP;

public:
    typedef UChar Image_Trf;
    
    static const int MaxCachePart = 8;

    static const Image_Trf     // * Define all possible image orientations.
        Op_No   =    0, //  Operator e
        Op_90   =    1, //  Operator 4
        Op180   =    2, //  Operator 2 = 4^2
        Op270   =    3, //  Operator 4^3 ='4^-1
        OpMix   =    4, //  Operator mx
        OpMiy   =    5, //  Operator my
        OpMiu   =    6, //  Operator mu
        OpMiv   =    7, //  Operator mv
        OpIni   =   64, //  Operator flag for init (Do not update CuOpe at init time.
        OpNIn = ~OpIni; //  Mask to ignore OpIni.
    
private:
    
    // Define the static image cache.
    
    char       *fname_; // The Complete filename (or path) of the image file.
    IIde_t      ident_; // The attached Unique Integer identifier.
//  UInt32      uflgs_; // Room for any user flags. 
    Image_Trf   CuOpe_, // The current pixmap orientation transformation.
                OrOpe_; // The original pixmap orientation transformation.

    static void        ClearCache();    // Erase all cache Image_MAP identiers to force the ...
                                        // ... reloading ///except for the specified index.

    GLubyte    * Check( int id = 0);    // Select Slide Cache Entry (in CurrEnt) and return ...
                                        // ... its pixel map or NULL if not exist.

    void        MapCp2Oth( UInt32 );    // Copy the Current Slide Cache entry to same slide ...
                                        // ... entries in other cache partitions.

    void    UnDTrf( Image_Trf trf );    // Perform complex pixel map transformations.

protected:
    
    // To build the cache with its predefined size.
    void Image_Init( GLint siz = DEFAULT_CACHE_SIZE );


public:

    // Cache Splitting functions.
    static void CacheSplit( int );
    static void CacheMerge( int );

    // The constructor is just to allocate and initialize the RGBImage.
    Image_REF( const char *, IIde_t = 0 );
    Image_REF( const uchar *, IIde_t = 0 );
    // The destructor free all location of this image.
    ~Image_REF();

    // Alternate constructor for memory image.
    static Image_REF * Image_MEM( const uchar *, IIde_t = 0 );
    
    // Some service routines for image.
    void FName( char * fname ) { fname_  = fname; }
    void Ident( IIde_t ide ) { ident_ = ide; }

    char * FName() { return fname_; }
    IIde_t Ident() { return ident_; }

    int   CurOpe() { return CuOpe_; }
    void  CurOpe( int fl ) { CuOpe_ = fl; }
    int   OriOpe() { return OrOpe_; }
    void  OriOpe( int fl ) { OrOpe_ = fl; }
/*
    int    FlgTst( int fl ) { return uflgs_ & fl; }
    int    FlgTvl( int fl ) { return (uflgs_ & ~fl) == fl; }
    void   FlgSet( int fl ) { uflgs_ |=  fl; }
    void   FlgClr( int fl ) { uflgs_ &= ~fl; }

    int    FlgVal() { return uflgs_; }         
    void   FlgVal( int fl ) { uflgs_ = fl; }
*/
    // Optional specified directory.
    void UsedPath( const char * );
    const char * UsedPath();
    
    // Image Cache Initializer.
//  void InitCache( GLuint siz = DEFAULT_CACHE_SIZE );
    
    // The Image Get methode Read the image file from the file path parameter ...
    // ... and set it in the Image Cache, the return value is 0 on
    // success. -1 on error.
    GLubyte * Get( const char *, int id = 0, int = 0 );     // Reentrant Get() form (without use of UsedPath).
    GLubyte * Get( int id = 0, int = 0 );                   // Not reentrant Get() form using the UsedPath facility.

    int  Write( const char *, int = 0 );                    // To create an image copy.

 ///   // Release the RGBImage( all image location are free (with possible saving actions).
 ///   void  Release();

    
    // To get the Image, pixels sizes and data (from class Image_MAP).
    GLint W();
    GLint H();
    GLint P();
    GLint E();

    GLubyte *Map();

    // To get the Pixmap.
    //const GLubyte * Map();
    
    // To transform image (Rotations and symetries).
    int  Transform( Image_Trf, const char*, int id = 0 );


};


#endif

//
// end of <PW-Id>.
//
