//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module  to analyse a directory tree.
//
//


//#include <sys/time.h>
//#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <dirent.h>
//#include <unistd.h>
//#include <stdlib.h>
//#include <time.h>
#include <errno.h>
#include <string.h>
#include <stdarg.h>


#include "Service_DIR.h"


#define MAX_ERROR 16


static const int MaMi = 'a' - 'A';

void SrvDir::SetFltExt( const FTypLst extb ) {

    char         * str;
    char            ch;
    int   ii,  jj,  ln;

    ii = ln = 0;
    while ((extb[ln])) ln++;  // Evaluate the size of extensions size.
    if (typls_) {
        while ((str = typls_[ii++])) { if (str) delete[] str; }
        delete[] typls_;
    }
    typls_ = new char *[ln+1];
    for(ii = 0; ii < ln; ii++) {
        str = strdup( extb[ii]);
        if (TstFlg( Dir_NCase )) {
            jj = 0;
            while ((ch = str[jj])) {
                if ((ch >= 'a') && (ch <= 'z')) ch -= MaMi;
                str[jj] = ch;
            }
        }
        typls_[ii] = str;
    }
    typls_[ln] = 0;
} // void SrvDir::SetFltExt( DirFiltre_t flt ).



// Small routine to reject any directory entries as "." or "..".
int  SrvDir::Check_FName( const char * nm ) {
    int ok = 1;

    if (nm && nm[0]) {
        if (nm[0] == '.') {
            if (!nm[1] || (nm[1] == '.' && ! nm[2])) ok = 0;
        }
    } else ok = 0;
    return ok;
} // int  SrvDir::Check_FName( const char * nm ).



// Small Filter member to check matching of filename with accepted filetypes.
int  SrvDir::Filter( int kn, const char * nm ) {
    const char * p = nm + strlen( nm );
    char  ch, buf[16];
    int ii = 0;

    if (!kn) return 0;                  // No filter for directory.

    while (p != nm && (*p) != '.') p--; // Loop to find the last period of nm.
    if (p == nm) p = "\n";              // '\n' is used to design a null extension.
    if (p[1]) p++;                      // for filename end by '. it is the extension.
    ii = 0;
    while ((ch = *(p++)) && ii < 15) {
        if (TstFlg( Dir_NCase )) { if ((ch >= 'a') && (ch <= 'z')) ch -= MaMi; }
        buf[ii++] = ch;
    }
    buf[ii] = 0;
    ii = 0;
    // Loop to check for each file extension.
    while (typls_[ii]) {
        if (!strcmp( typls_[ii], buf )) break;
        ii++;
    }
    return (typls_[ii]) ? ii : -1;
} // int SrvDir::Filter( const char * nm ).



// Scan Error Manager.
int  SrvDir::Error_Manager( int ie, const char * frm, ... ) {
    va_list                 ap;
    int                      n;
    char   buf[512],  fmt[128];
    const char * mne = "SrvDir : To Many (%d) Error => Stop scan on Fatal errors.";

    snprintf( fmt, 127, " *** SrvDir%sError %3d : %s", (ie < 0)? " Fatal ": " ", ie, frm );

    va_start( ap, frm );
    ::vsnprintf( buf, 511, fmt, ap );
    va_end( ap );

    if (ehdl_) ie = ehdl_( ie, buf ); else fprintf( stderr, "%s\n", buf );

    if (ie > 0 && ++nerr_ > MAX_ERROR) {
        snprintf( buf, 511, mne, MAX_ERROR );
        if (ehdl_) ie = ehdl_( -1, buf ); else fprintf( stderr, " %s\n\n", buf );
        ie = -1;
    }
    return ie;
} // int  SrvDir::Error_Manager( int ie, const char * frm, ... ).



int  SrvDir::Scan_Work() {
    DIR                  * dir;                 //  Directory file descriptor used by opendir(), ...
                                                // ... readir() and closedir().
    struct dirent        * dsc;                 // Directory entry descriptor - from readir().
    struct stat          entbf;                 // File or Sub-directory descriptor - from stat().
    int  ndir, nfil, nerr, knd;
    int  strs =  0,  ierr =  0;

    // Open the directory.
#ifdef _HAVE_FL_UTF8_HDR_
    if (!(dir=opendir( path_.Path() )))
#else
    if (!(dir=opendir( path_.Path() )))
#endif
    {   // Error to open the directory.
        ierr = Error_Manager( -2, "Cannot open the directory :\n\tpath = \"%s\",\n\tSysMsg : %s\n",
                                  path_.Path(), strerror( errno ) );
        return -1;                              // ... to stop scan at all nesting level.
    }

    // Open is a success.
    path_.Set( 0, 1 );  nlvl_++;                // Append a directory separator to path.
    if (dibg_) dibg_( path_.Path() );           // Call the user routine for start directory scan.

    ndir = nfil = nerr = 0;                      // Init the count of directories, files and error(s).

    while ((dsc = readdir( dir ))) {              // Read a directory entry.
        if (Check_FName(dsc->d_name)) {         // Perform check to skip "." and "..".
            path_.Set( dsc->d_name, 0 );        // Append the entry name to path.

#if defined( _WIN32 ) && !defined( _CYGWIN_ )
            if (stat( path_.Path(), &entbf ))   // Get the entry kind.
#else
            if (TstFlg( Dir_SLink )) ierr = stat( path_.Path(), &entbf );
            else ierr = lstat( path_.Path(), &entbf );
            if (ierr)
#endif
            { // in stat/lstat error.
                ierr = Error_Manager( 3, "%s\n\ttpath = \"%s\", \n\tSysMsg : %s\n",
                                         "(l)stat error on directory entry :",
                                         path_.Path(), strerror( errno )
                                    );
                if (ierr < 0) {
                    if (dien_) dien_( ndir, nfil );
                    nlvl_--;
                    closedir( dir );
                    return ierr;
                }
            }
            else
            { // Entry access OK.
                switch(entbf.st_mode & S_IFMT) {// Select the kind of directory entry.
                    case S_IFDIR: {
                        // For directories we restrick to folders with only one link.
                        if (entbf.st_nlink == 1 || TstFlg( Dir_MLink ) ) {
                            knd = Filter( 0, dsc->d_name );
                            if (knd < 0) break;
                            ierr = Scan_Work();
                            if (ierr < 0) {
                                nlvl_--;
                                closedir( dir );
                                path_.Clear();
                                return ierr;
                            } else ndir++;
                        }
                        break;
                    }

                    case S_IFREG: { // For regular file.
                        // Check for file extension is matching.
                        knd = Filter( 1, dsc->d_name );
                        if (knd >= 0) {
                            if (fkey_) knd = fkey_[knd];
                            nfil++;
                            if (rfil_) rfil_( knd, path_.Path() );
                        }
                        break;
                    }

                    default: ; // Ignored entry.
                }
            }
            path_.Rem();
        }
    } // End loop on all directory entries.
    if (dien_) dien_( ndir, nfil );
    nlvl_--;
    closedir( dir );
    return ierr;
} // int  SrvDir::Scan_Work( ).



int  SrvDir::Scan( const char * dn ) {
    int ie;

    path_.Set( dn, 0 ); // Set and fixe the base directory level and path.
    nlvl_ = -1;
    ie = Scan_Work();
    path_.Clear();
    nlvl_ =-1;
    return ie;
} // int  SrvDir::Scan( const char * dn ).


//
// ------------------------------------------------------------------------------
//

//
// Main for Test (defined if DIR_DEBUG) is defined with compilation command :
//

#ifdef DIR_DEBUG

#define RECURSE_MAX  16;


SrvDir     sca_dir;
int     ncol =   1;

        
static void PrtSpace( int n ) {
    for (int ii=0; ii<n; ii++) printf( " " );
} // static void PrtSpace( int n ).



//
// Our specific routines called by sca_dir.Scan() :
//
static int Err_Handler( int ie, const char * msg ) {
    
    printf( "\n\n *** Our handler called with the following message\n" );
    printf( msg ); printf( "\n\n" );
    return ie;
} // static int Err_Handler( int ie, const char * msg ).



static int DirBegin( const char * nam ) {
    PrtSpace( ncol ); printf( " *BD* We enter in the directory %s of deep = %d\n",
                              nam, sca_dir.NestLevel() );
    PrtSpace( ncol ); printf( " *BD* complete path is now \"%s\"\n", sca_dir.Path() );
    ncol += 2;
    return 0;
} // static int DirBegin( const char * nam ).



static int DirEnd( int nd, int nf ) {
    ncol -= 2;
    PrtSpace( ncol ); printf( " *ED* We have find %d directories and %d selected files\n", nd, nf );
    PrtSpace( ncol ); printf ( " *ED* We return to previous directory at the deep %d\n",
                               sca_dir.NestLevel()
                             );
    return 0;
} // static int DirEnd( int nd, int nf ).



static int RegFile( int ty, const char * nam ) {
    PrtSpace( ncol ); printf( " *F* ->  we select the file \"%s\n", nam );
    return 0;
} // static int RegFile( int ty, const char * nam ).



// g++ -DDIR_DEBUG -o dirscan Service_DIR.cxx Service_Uti.cxx
//
// use with the command  "./dirscan [-f<flags>] <base_dir> <t1> <t2> t3> ...
//
// were flags 0 the default, 1 = Dir_MLink, 2 = Dir_SLink, 3 = Dir_MLink|Dir_SLink
// <t1>, <t2> ... the different selected file types.
//

int main( int argc, char ** argv ) {
    // Default we scan to look for these file extensions :
    const char * dxtb[] = { "jpeg", "JPEG", "jpg", "JPG", "png", "PNG", "bmp", "BMP", 0 };
    SrvDir                   sca;
    int       ii = 0,     ie = 0;
    char           * arg  =    0,
         * path = strdup( "./" );
    const   char *     tbext[65];
    int  hlp= 0, flg= 0, nar= -1;

    tbext[0] = 0;
    for(ii = 1; ii < argc; ii++) {
        arg = argv[ii];
        if (arg && arg[0]) {
            if (arg[0] == '-') {
                switch (arg[1]) {
                    case 'F': case 'f':
                        if (arg[2] >= '0' && arg[2] <= '3') flg = arg[2] - '0';
                    break;
                    case 'H': case 'h':
                        hlp = 1;
                        break;
                    default: ie = 1; // Unkown option.
                }
            } else {
                if (nar < 0) {
                    path = arg;
                    nar++;
                } else tbext[nar++] = arg;
            }
        }
    }

    if (nar <= 0) {
        nar = 0;
        while (dxtb[nar]) { tbext[nar] = dxtb[nar]; nar++; }
    }
    tbext[nar] = 0;
 
    if (ie || hlp) {
        printf( "    Use Service_DIR program by the command :\n\t %s %s\n\n",
                argv[0], "[-f<flags>] <base_dir> <t1> <t2> t3> ..." );
        printf( " Where :\n\t<flags> is 0, 1, 2 or 3 for Dir_MLink, Dir_SLink, Dir_MLink|Dir_SLink,\n" );
        printf( "\t<base_dir> is the root directory of the files tree to examine\n" );
        printf( "\t<t1>, <t2>, <t3> ... form the list of file types to lokk for.\n\n" );
        printf( " As result %s will print the list of path selected files\n\n", argv[0] );
        printf( " The option -h wil print this text.\n\n" );
    }

    printf( " We look for files with extensions in  %s :\n", path );
    ii = 0;
    while (tbext[ii]) {
        printf( "  %2d / %s\n", ii+1, tbext[ii] );
        ii++;
    }
    printf( "\n\n" );

    // Now we can work !
    if (!ie) {
        sca_dir.ErrHdl( Err_Handler );
        sca_dir.Setup( DirBegin, DirEnd, RegFile );
        sca_dir.SetFltExt( (SrvDir::FTypLst) tbext );
        sca_dir.SetFlg( flg );

        ie = sca_dir.Scan( path );
        printf( "\n\n the final scan return value is %d\n\n", ie );
    }
    return ie;
} // int main( int argc, char ** argv ).






#endif


//
// end of <PW-Id>.
//
