//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to analyse a directory tree.
//
//


#ifndef SERVICE_DIR_H
#define SERVICE_DIR_H

//#include <sys/types.h>
#include <sys/stat.h>
//#include <unistd.h>
//#include <errno.h>


#include "Service_Util.h"



class SrvDir {
public:
    // Use do define a user catch error.
    typedef int (*ErrCatch_t) ( int, const char * );

    // When these next routines return 0, the directory/file will be ignored.
    typedef int (*DirBegin_t) ( const char * );
    typedef int (*DirEnd_t)   ( int, int );
    typedef int (*DirFile_t)  ( int, const char * );

    // Define a file types list.
    typedef char    ** FTypLst;

    typedef enum {
        Dir_MLink =  1, // Scan take in account the multi-link [default No].
        Dir_SLink =  2, // Scan take in account the symbolic links [default No].
        Dir_NCase =  4  // Suppress the case distinction [default No.].
    } Dir_Flags_t;

private:
    ErrCatch_t   ehdl_; // Call on error with argument error code.
    DirBegin_t   dibg_; // Call with argument the directory filename.
    DirEnd_t     dien_; // Call with arguments numbers of directories and regular files.
    DirFile_t    rfil_; // Call with arguments related file type index and filename.

    FilePath     path_; // File/Directories Path Manager.
    FTypLst     typls_; // List of matching regular file types.
    int          flgs_; // Scan Flags.
    int        * fkey_; // File types kind (used to manage file types synonymes.
    int          nerr_; // The error count.
    int          nlvl_; // The Directory nesting level from Base/root.

    int  Check_FName( const char * );

    int  Error_Manager( int, const char *, ... );

    int  Scan_Work();

protected:
    virtual int Filter( int, const char * );

public:
    SrvDir()  { typls_ = 0; fkey_ = 0; nerr_ = flgs_ = 0; nlvl_ = -1; }  // Constructor.
    ~SrvDir() { typls_ = 0; fkey_ = 0; path_.Clear(); } // Destructor.

    // Enable the SrvDir Structure with :
    //    DirFTyp arg, the list of accepted type/ext. of file entries (ended by NULL),
    //    a flag 
    //    and in last arg., the path of root directory.

    // Routine To Clean User routines pointers.
    // Warning ! This routine should not be used in the coroutines called by scan.
    void Clean() { ehdl_ = 0; dibg_ = 0; dien_ = 0; rfil_ = 0; nerr_ = 0; nlvl_ = -1; }

    void SetFlg( int v ) { flgs_ |= v; }
    void ClrFlg( int v ) { flgs_ &= ~v; }
    int  TstFlg( int v ) { return flgs_ & v; }

    // To set an user catch routine (else a default error message is produced).
    void ErrHdl( ErrCatch_t r ) { ehdl_ = r; }
    void ErrZero() { nerr_ = 0; }

    // Setup the scan process.
    // Arg 1 : The routine called when a directory is found,
    // Arg 2 : The routine called when a end of directory is reached.
    // Arg 3 : The routine called when a regular file is matching.
    // Warning ! This routine should not be used in the coroutines called by scan.
    void Setup( DirBegin_t dibg, DirEnd_t dien, DirFile_t rfil )
        { dibg_ = dibg; dien_ = dien; rfil_ = rfil; }

    // To specify the file type list (ended by 0) end file ntype number (for synonymes).
    void SetFltExt( const FTypLst = 0 );

    // Perform the Tree Scan process to find any file of specified types.
    // The unique argument is the base/root of the directories/files tree.
    // A return != 0 is used to signal error during the scan.
    int  Scan( const char * );

    // To get the complete path of the object (to use in the user co-routines). 
    const char * Path() { return path_.Path(); }

    // To get the internal nesting level (or current relative directory deep).
    int NestLevel() { return nlvl_; }

};



#endif


//
// end of <PW-Id>.
//
