//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software :
//
//   Insymbol module environment to manage any Application Setupfiles.
//


#ifndef SETUPMAN
#define SETUPMAN


#include <stdio.h>

#include "ErrMsgMan.h"



#define  MAXIDSIZE           32
#define  MAXLINESZ          132



//typedef void (ErrMsgDisplay)( int, const char *, const char * );


// External symbol definitions  for C/C++ manageable variables.
// The symbol must be in the same order that for the insternal type symbol.
typedef enum { SetUpVar = 0,  // To define a constant identifier (for futur).
               SetUpInt,      // C type int and int [].
               SetUpFlt,      // C type float and float[],
               SetUpStr,      // C type char * and char *[],
               SetUpDIn,      // Dynamicaly allocated array of int.
               SetUpDFl,      // Dynamicaly allocated array of float,
               SetUpDSt,      // Dynamicaly allocated array of char *,
               SetUpRec,      // Pseudo record of previuos C types.
               SetUpQue,      // SetUp Que of the free base types.
               SetUpCtI,      // C const int (for futur).
               SetUpCtF,      // C const float (for future).
               SetUpCtS,      // C const char * (for future).
               SetUpEof       // End of SetUpIde and SetUpDsc list.
} SetUpSym;


typedef struct {                // Define the dynamic array type ...
    int      size;
    union { int   * i; // ... of integers,
            float * f; // ... floats,
            char ** s; // ... or strings.
    } tab;
} SetUpDynTab;


typedef void *      SetUpQueue; // User definition of a Queue of objects.


// List element record definition.
typedef struct { SetUpSym        vtype; // Type of value.
                 int             vsize; // Size for array
                 void          * vaddr; // Address where deposite (or value for constante).
               } SetUpDsc;

// Identifier record Definition
typedef struct { const char   * idname; // Name of the identifier
                 SetUpDsc       vdescr; // Related descriptor
               } SetUpIde;



#define AD( v ) ((void *)(&v))



extern  int   BadSetUpFile;     // Global flag for Fatal SetFile with syntax Error.

//
// Define the SetUpMan functions.
//

//void SignalError( int ie, char const *msg, const char *id );


// Function to specify the directory path of the error messages.
void SetUpSolveLogPath( const char * spath, char * &path, int &isz );
void SetUpInsPath( const char *path );

// To initialize a Queue list of value.
SetUpQueue SetUpCreateQueue( SetUpSym typ );

// To destroy a queue.
void SetUpQuErase( SetUpQueue&, int );

// To test if the queue is not empty.
int SetUpQuNoEmpty( SetUpQueue );

// Function to read the Setup File (fnam),
// with the identifier table idetab.
// and the Error syntax message routine ErrFnc.
// The routine does not signal when the setup file is not existing,
// In this last case, the previously SetUp Variable values are preserve*d.
void SetUpRead( const char * fnam, SetUpIde const idetab[] );

// The equivalent function to rewrite (supersheding) the setup file.
void SetUpWrite( const char * fnam, char const *head, const SetUpIde idetab[] );


// *** Specific functions to manage the SetUpMan Queues ***

// Function to set the found element of index idx as the current on.
// with idx =-1 we set current the first queue element, and
// with idx = 0, we select as current the next of the previously current.
// if the element does not exist, the function return 0.
int SetUpQuLocate( const SetUpQueue queue, int idx );

// These next functions are used to return the values and related data if
// the current the element. If no current element is selected the 
// functions return 0, 0.0 or NULL.
// Note: The string is the string in the Queue (not copied).
// This function return the data field of the element.
int    SetUpQuGetI( SetUpQueue queue );
float  SetUpQuGetF( SetUpQueue queue );
char * SetUpQuGetS( SetUpQueue queue );
void * SetUpQuGetData( SetUpQueue queue );


// Functions to append a new element in the Queue.
int  SetUpQuAppendI( SetUpQueue queue, int iv );
int  SetUpQuAppendF( SetUpQueue queue, float fv );
int  SetUpQuAppendS( SetUpQueue queue, const char * sv );

// function to set a value to the element data field.
void SetUpQuPutData( SetUpQueue queue, void * data );

// function to remove one object from the list
void SetUpQuRemove( SetUpQueue queue, int idx );

#endif

//
// end of <PW-Id>.
//


