//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Module for a View (Image and or text) environment.
//


#ifndef VIEW_WIN_GL_
#define VIEW_WIN_GL_

class View_Win : public Fl_Gl_Window {
public:

    typedef enum {
        Img_Not         =    0,
        Img_Up          =    1,
        Img_Left        =    2,
        Img_Center      =    4,

        Img_UpLeft      = Img_Up|Img_Left, // Corner Up-Left
        Img_UpRight     =          Img_Up, // Corner UP_Right or (Up and no Left)
        Img_DownRight   =         Img_Not, // Corner Down-Right or (no Up and no Left).
        Img_DownLeft    =        Img_Left, // Corner Down-Left.

        Img_C_Left      = Img_Center|Img_Up|Img_Left,
        Img_C_Up        = Img_Center|Img_Up,
        Img_C_Right     = Img_Center,
        Img_C_Down      = Img_Center|Img_Left
    } ImgPosition;

private:

    GLint       w_widt, w_high, // Width and High of GL Window Image space in pixels.
                w_hwid, w_hhig, // Half GL Window sizes (Screen pixels).
                i_widt, i_high, // Width and high of the image in image pixels.
                i_hwid, i_hhig, // Half sizes of image.

                i_shww, i_shhh, // Showed half zoom rectangle sizes (Image pixels).
                i_cenx, i_ceny, // Current center of showed rectangle.
                i_zshw, i_zshh, // New zoom rectangle (Image pixels).
                i_zcex, i_zcey, // Zoom rectangle center coordinates (Image pixels).
                img_x1, img_y1, // The limits of the current image.
                img_x2, img_y2, //
                cur_x1, cur_y1, // Current limits of the displayed image.
                cur_x2, cur_y2,
                zre_x1, zre_y1, // Mouse Zoom rectangle window pîxel coordinates.
                zre_x2, zre_y2,
                i_npix, i_nrow, // Visible Part of image.
                i_spix, i_srow, // Skipped(left/low) part of the image.

                i_pixs;         // Size of a pixel(1=luminance, 3=RGB, 4=RGBA).

    GLint       ViewReady  = 0, // OpenGL window Init Flag.
                ChartMap   = 0, // Flag when a ranking Chart/Map is displayed.
                UsedButton,     // memory for mouse button use.
                MouseStat  = 0, // Used button for Zoom ans Mouse status.
                ZoomStatus = 0, // Status to flag a zoom/sceolling request.
                FirstView  = 0, // Signal original view setup when set to one.
                SetScaVal  = 0, // Flag to force a specified scale.
                X_shift    = 0, // Shift (for scrollbar along x or y.
                Y_shift    = 0;

    GLfloat     r_scale  = 1.0, // Internal Scale in Screen-Pixel/Slide-Pixel.
               rr_scale  = 1.0; // Relative user scale.

    GLubyte         * Curr_Map; // The map of the current slide.

    int            ViewerReady, // Viewer Init flag.
                   ViewRkgFlgs; // Viewef status Flags


    void MouseDown( int, int, int );
    void MouseDrag( int, int, int );
    void MouseUp(   int, int, int );
    void XYinImage(  int &, int & );


public:
    View_Win( int, int, int, int, const char * = 0 );

    void Geometry( ImgPosition );
    void ChangeFont();
    void Quit();
    void ToPrint();


protected:

    int  handle( int );

    void draw();

}; // class View_Win.



#endif


//
// end of <PW-Id>.
//
