//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Environment of Service routines/object.
//


#ifndef DIAVIEWER_SRV_H
#define DIAVIEWER_SRV_H

#include "Service_UTIL.h"
#include "Service_IO.h"
#include "SetUpMan.h"




// Define MkDir as the same for all operating system.
#if defined( WIN32 ) && !defined( _CYGWIN_ )
# define MkDir( p ) mkdir( p )
#else
# define MkDir( p ) mkdir( p, S_IRWXU|S_IRGRP|S_IROTH )
#endif

#define MAX_SLI_DISPLAY 256



//
// Some global definitions.
//

//
// Define the DiaViewer Version for possible future changes.
//
#define DIAVIEWER_VERSION                     1
#define DIAVIEWER_SUB_VERSION                 2
#define DIAVIEWER_RELEASE                 "A01"
#define DIAVIEWER_VERFORMAT "DVW %3d.%3.3u-%3s"

// The next definition must be in agreement with the previous one and ...
// ... the fixed format "DVW %3d.%3.3u-%3s"
#define DIAVIEWER_STRVERS     "DVW   1.001-A01"


// User environment file space (depending of operating system).

#if defined( WINHOME ) || defined( WIN32 ) 
# define USER_ENV "LOCALAPPDATA:.DiaViewer,LOCALAPPDATA:"
# define USER_DIR "USERPROFILE:"
#else
# define USER_ENV "HOME:.DiaViewer,HOME:"
# define USER_DIR "HOME:"
#endif



#define PATH_ALLOC_STEP 64


// AccPtr is the standard replacement of ObjPtr (defined in Service_ENV.h).
typedef         void *  ObjPtr; // Define a pointer a undefined object.



extern int  screen_w, screen_h; // Usable size of the screen (to size any windows).

extern int              svargc; // To keep the task arguments number ...
extern char          ** svargv; // ... and the task arguments list.
extern char        *  User_Dir; // Path directory of the user.

extern SetUpDynTab   VolToOpen, // Table of index of volume to open on start.
                     VolP2Open, // Table of volume to open when the application start (temp.).
                      WinTable, //  To keep all windows (to create at start time) data.
                     //  The next tables should be replaced by the table WinTable.
                     WinVolume, // Table of assigned Volume for each window.
                     WinSelSli; // Table of values to select previous dispalyed slides.

extern int            rktb_wid, // Slide Ranking map ...
                      rktb_hig, // ... sizes.
                      rktb_tsz, // Slide Ranking Map Title font size ...
                      rktb_esz; // ... and table element Font size.

extern int            vltb_wid, // Window width ...
                      vltb_hig, // ... and high.
                      vltb_tsz, // Font size for the text title ...
                      vltb_esz; // ... and table elements.

extern int            slid_dig, // Number of figures for Slide#,
                      film_dig, // Number of figures for Film#,
                      fold_dig, // Number of figures for Directory/folder,
                      flmn_max, // Maximum value of film number (#),
                      slin_max, // Maximum value of slide number (#),
                      dirslisz, // Max. number of slides/folder in the target volume,
                      dirdirsz; // Max. number of Folder/folder in the target volume.

extern char         * slid_hde, // Slide filename header string,
                    * slid_sep, // Slide filename separator string,
                    * fold_hde, // Folder/Directory filename header string.
                    * fold_tra; // Folder/Directory filename trailer string.

extern char         * tvol_pth, // The Path of ranking target volume.
                    * tvol_nam; // The Name of ranking target volume.




//
// Main SetUp definitions
//


extern LogFile            LogF; // Log file to write historic and/or operation debug.

extern char       MsgBuf[1024]; // Buffer for any message.

extern FilePath      *   CPath; // The CPath common FilePath must be visible out of any class.

extern int  win_dx,     win_dy; // Default Window size.

extern int          SlidePrior, // Flag for scan priority for directories ...
                                // ... (for 0) or for slides if not 0.
                    NativeOFil; // Flag to use native openfile and directory.


//
// Image_Ref definitions
//
extern      int   IIdeOverflow, // Flag for IIde_t overflow.
                  SliCacheSize, // Size to use for Image Cache.
                  IIdeMaxSli,   // Maximum possible # of a slide.
                  IIdeFld[2];   // Sizes of ident fields [0/1] slides/Directories. 

//
// Main Program and GL definitions
//
extern ObjTable   OpenVolTable; // The table of all opened slides volumes ...


extern int           PrtFromGL, // Flag to control when we print slide from screen image.
                    SlidePrior, // Flag for scan priority for directories ...
                                // ... (for 0) or for slides if not 0.
                     ScanNoLim, // Scan limited to sub-directories limits (default no).
                    NativeOFil; // Flag to use native openfile and directory.

extern char      * OpenVolPath, // Default Open Volume Path.
                 * UserHelpUri, // User Help HTML URI.
                * SlideEditPrg; // Slide Editor program.


//
// Some external function definitions.
//

//const char * DLG_DirChooser( const char * msg, const char * fnm ); // From DL module.




#endif

//
// end of <PW-Id>.
//
