//
// "$Id$"
//
// implementation of class Fl_Gl_Device_Plugin for the Fast Light Tool Kit (FLTK).
//
// Copyright 2010-2014 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     http://www.fltk.org/COPYING.php
//
// Please report all bugs and problems to:
//
//     http://www.fltk.org/str.php
//

// #define DIAVIEWER_DIA_PRINT


// #include <config.h>
#include "FL/Fl.H"
#include <FL/Fl_Printer.H>
#include <FL/Fl_Gl_Window.H>
#include <FL/Fl_RGB_Image.H>

#include <GL/gl.h>              // To use the GL integer and float types.

#include "ImageMan_REF.h"
#include "DiaViewer_GL.h"



//
// New form to use a part of Fl_Printer.
//
  
  
  

static Fl_RGB_Image * BuildImage( Image_REF * src, GLint xx, GLint yy, GLint ww, GLint hh )
{
  int       src_rsz,   dst_rsz,
            src_wid,   src_hig,
            dst_siz,  ira, ipc,
                            pp;
  
  uchar   * src_cra, * src_cco,
          * dst_cra, * dst_cco;
  uchar   * src_map, * dst_map; // Define the source and destination pixel map pointers.

  Fl_RGB_Image         * flimg;      


  pp            =     src->P(); // Get the pixel size and raw alignement mask. 
  src_wid       =     src->W(); // Get the original width (in pixels) of image.
  src_hig       =     src->H(); // Get the original hight (in pixels) of image.
  src_map       =   src->Map(); // Get the source (src) image pi=xel map.

  if (ww > src_wid) ww = src_wid;
  if (xx < 0) xx = 0;
  else if (xx + ww > src_wid) xx = src_wid - ww;

  if (hh > src_hig) hh = src_hig;
  if (yy < 0) yy = 0;
  else if (yy + hh > src_hig) yy = src_hig - hh;

  src_rsz       =   pp*src_wid; // Get the original size (in byte) of image raws.
  dst_rsz       =        pp*ww; // Get the size (in byte) of final pixel map raws.
  dst_siz       =   dst_rsz*hh; // Get the final pixel map image size.

  dst_map = new GLubyte[dst_siz];       // Allocate the print map and ...

  src_cra = src_map + yy*src_rsz+xx*pp; // Set the src current raw -> first pixel of the src image (first dst pixel) (at image bottom).
  dst_cra = dst_map + dst_siz;          // dst_raw -> first not existing dst pixel map raw (below the bottom image).
  for(ira = 0; ira < hh; ira++) {
    dst_cra -= dst_rsz;                 // dst_cra -> first pixel of src current raw (starting from bottom raw).
    dst_cco  = dst_cra;                 // dst_cco = dst_cra to init the dst raw filling.
    src_cco  = src_cra;                 // src_cco -> first byte to copy in the destination.
    for(ipc = 0; ipc < dst_rsz; ipc++)  // Loop to fill all pixels (dst_rsz bytes) of the raw.
      *(dst_cco++) = *(src_cco++);
    src_cra += src_rsz;                 // src_cra -> first pixel of dst for next raw (starting from the top raw).
  }

  flimg = new Fl_RGB_Image( dst_map, ww, hh, pp, dst_rsz );
  flimg->alloc_array = 1;
  
  return flimg;
} // static Fl_RGB_Image * BuildImage( Image_REF * src, GLint xx, GLint yy, GLint ww, GLint hh ).



void Map_Print( Fl_Printer * lpt, Image_REF * img, int xx, int yy, int ww, int hh )
{
//Fl_Box           box;
  Fl_Double_Window * w;
  Fl_RGB_Image   * rgb = BuildImage( img, xx, yy, ww, hh );

  w = new Fl_Double_Window( rgb->w(), rgb->h() );
  
  w->image( rgb );
  rgb->draw( 0, 0 );
  
  w->end();
  lpt->print_widget( w );

  delete rgb;

} // static void Map_Print( Fl_Printer lpt, Image_REF * img, int xx, int yy, int ww, int hh ).



//
// End of "$Id$".
//
