//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Ranking context and map module environment.
//
//

#ifndef DIAVIEWER_RKGCN
#define DIAVIEWER_RKGCN 1

//#include <sys/types.h>
//#include <sys/stat.h>


//#include "SetUpMan.h"

#include "DiaViewer_DIA.h"
#include "DiaViewer_GL.h"



typedef void (*Slide_Process_t) ( SliEntry * );

class Text_Display;

class RkgTabCnt {
private:
    Text_Display    *   DspTxt; // Pointer to the text display.

public:
    int     Frs_Flm,   Flm_Siz, // First film ", Last film # - Frs_Flm.
            Flm_Esz,   Sli_Siz, // Number of Film, Maximum slide number,
            Sli_Tsz,   Sta_Tli; // Total Slide table size, Text Table First line index.
    SliEntry       ** SliTable, // Table of all volume slides.
                  *** FlmTable; // Table of all Film.
    UInt16          * FlmIdeNb, // Table of film #.
                    * FlmRowNb, // Table of film # for each text row.
                    * FlmRowSz; // Table of film sizes.
    DiaViewer_GL    *   SrcWin; // Source Window.
    VolEntry        *   SrcVol; // Source Volume.
    DirEntry        *   SrcDir; // Source root directory.
    int                 Active, // Flag to signal active Text Display.
                        TmpMap; // Flag for Temporary/Ranking_Check Map mode.

private:
    void Clear();
    void CountFillFilm( DirEntry * dir );
    int  FlmSliCount_( DirEntry * );

public:
    RkgTabCnt( DiaViewer_GL * );
    ~RkgTabCnt();

    void Reset();

    int  FlmSliCount();
    void FlmSliCount( int &, int &, int & );

    void RequiredSliEval( int, int &, int & );

    int  AnalyseFlmSli( DirEntry * );

    void MouseCallBack( int, int, int );
    void ExitCallBack();

    int  FlmSliChart( int );

    void SlideScan( Slide_Process_t );

    static int TmpChartMap( DiaViewer_GL * );

    void TextExit();

};

#endif


//
// end of <PW-Id>.
//
