//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//



//
// DiaViewer View Manager module.
//


void DiaView::SaveVolStatus()
{
  int flg   =  FlgVal()&Context_Viewer,
      wpc   =         Process->PrgPc(),
      wid   =         Process->PrgId();

  if ((flg != Curr_Vol->FlgVal())||(wpc != Curr_Vol->PrgPc())||
      (wid != Curr_Vol->PrgId())) {
    if (!(Curr_Vol->FlgTst( Context_MemImg ))) Curr_Vol->FlgVal( flg|Context_Update );
    Curr_Vol->PrgPc( this->Process->PrgPc() );
    Curr_Vol->PrgId( this->Process->PrgId() );
  }
} // void DiaView::SaveVolStatus().


};

void DiaView::Close_SubWindows()
{
//  printf( " FLG = %d\n", SwFTst( SwFlg_Ranking ) );
    if (SwFTst( SwFlg_Ranking ))  Rkg_Quit();
    if (SwFTst( SwFlg_Search ))   Search_Exit( 0 );
    if (SwFTst( SwFlg_SliChart )) /* SwFClr( SwFlg_SliChart ) */ ;
} // void DiaView::Close_SubWindows()



void DiaView::View_Init()
{
  Win_Init      =            0; // Do not recall it.

  // Get the DiaViewer Structure (class) adress.
  DiaViewer_UI *Uiw = Viewer_UIT[Win_UInb];

  // Keep the GL_display address for the new window.

  W_main        =  Uiw->w_main; // Pointer to the FLTK window, ...
  W_fdir        =    Uiw->fdir; // ... to first directory, ...
  W_pdir        =    Uiw->pdir; // ... to previous directory, ...
  W_fsli        =    Uiw->fsli; // ... to first slide, ...
  W_psli        =    Uiw->psli; // ... to previous slide, ...
  W_zoom        =    Uiw->zoom; // ... to the zoom slider, ...
  W_nsli        =    Uiw->nsli; // ... to next slide, ...
  W_lsli        =    Uiw->lsli; // ... to last slide, ...
  W_ndir        =    Uiw->ndir; // ... to next directory, ...
  W_ldir        =    Uiw->ldir; // ... and to last directory.

  W_xscroll   =  Uiw->x_scroll; // Pointer to t X and Y scroll bar, ...
  W_yscroll   =  Uiw->y_scroll;

  W_class       = Uiw->w_class; // ... to the classification button, ...
  W_path        =  Uiw->w_path; // ... to the Slide file path, ...
  W_text        =  Uiw->w_text; // ... and to the slide comment.

//W_slinbr    =  Uiw->w_slinbr; // Group to lock/unlock the slide numbers edition.
  W_sliid       = Uiw->w_sliid; // Slide Number.
  W_flmid       = Uiw->w_flmid; // Slide Number.
  W_parid       = Uiw->w_parid; // Slide Number.
  W_chpid       = Uiw->w_chpid; // Slide Number.
  W_lock        =  Uiw->w_lock; // To can change the lock button flag.
  W_ignor       = Uiw->w_ignor; // to clear and lock slide ranking data.
  W_autom       = Uiw->w_autom; // To can change the Auto Mode button flag.
  W_enrkg       = Uiw->w_enrkg; // To can change the rankind data button flag.
  W_title       = Uiw->w_title; // Slide anotation Text.

  W_seawin      =         NULL; // Init the Pointer to the search interface pointer.
  W_RkgMap      =         NULL; // Init the Pointer to any related Slide Chart Map.

  W_orient    =  Uiw->w_orient; // Orientation group.
  W_slcntx    =  Uiw->w_slcntx; // Context data group.
  W_brank     =   Uiw->w_brank; // Rankink group.
  W_iden        =    Uiw->iden; // Original orientation of slide.
  W_rp90        =    Uiw->rp90; // Slide rotation +90° (antcleari-clock wise).
  W_rm90        =    Uiw->rm90; // Slide rotation -90° (clock wise).
  W_r180        =    Uiw->r180; // Slide rotation of 180°.
  W_invx        =    Uiw->invx; // Slide mirror mx.
  W_invy        =    Uiw->invy; // Slide mirror my.
  W_invu        =    Uiw->invu; // Slide mirror mu.
  W_invv        =    Uiw->invv; // Slide mirror mv.

  W_Refer       =         NULL; // Pointer to current context reference.

  ViewerReady   =            0; // Set to Zero to force the load of first slide.
  ViewRkgFlgs   =            0; // Init Viewer flags.

  schp = spar = sflm = ssli= 0;// Initialize the search arguments.
  stxt          =         NULL;
} // DiaView::View_Init().





void DiaView::SaveVolStatus()
{
  int flg   =  FlgVal()&Context_Viewer,
      wpc   =         Process->PrgPc(),
      wid   =         Process->PrgId();

  if ((flg != Curr_Vol->FlgVal())||(wpc != Curr_Vol->PrgPc())||
      (wid != Curr_Vol->PrgId())) {
    if (!(Curr_Vol->FlgTst( Context_MemImg ))) Curr_Vol->FlgVal( flg|Context_Update );
    Curr_Vol->PrgPc( this->Process->PrgPc() );
    Curr_Vol->PrgId( this->Process->PrgId() );
  }
} // void DiaView::SaveVolStatus().








//
// end of <PW-Id>.
//
