//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer GL picture display manager.
//
//

#include "DiaViewer_GBL.h"
#include "DiaViewer_GL.h"
#include "DiaViewer_UI.h"
#include "DiaViewer_DCM.h"
#include "DiaViewer_V_MN.h"


//#define GL_DEBUG


// Pointer of Table of the different slide Viewer display.


DiaViewer_UI      ** Viewer_UIT =  NULL; // Pointer of Table of the different slide Viewer User Interface.
DiaViewer_GL      ** Viewer_GLT =  NULL; // Pointer of Table of the different slide Viewer display.


// Define the maximum of concurrent slide views).
int  MAXIMUM_VIEW = Image_REF::MaxCachePart;


// #define GL_DEBUG

VolEntry * svol1 = NULL,
         * svol2 = NULL;



int                             svargc; // To keep the task arguments number ...
char                         ** svargv; // ... and the task arguments list.

int     screen_w,       screen_h,       // Identify the screen size in pixel ...
        screen_x,       screen_y;       // ... and position (not used but referenced).

// int  w_width =  860, w_high  =  715, // Size of window #0.
//      ViewerReady     =            0; // OpenGL window Init Flag.

static int ViewerNumber =            0, // Viewer # of new viewer to create..
           ViewerNbWin  =            0, // Number of Viewer to create at start time.
           ViewerFather =            0; // Viewer Father # for the createtion of new window.


int     PrtFromGL       =            1; // Flag to select the print of Screen GL image.
                                        // It was a temporary default.

const char def_dtx[]    =    "No Name", // Default output when no name/text are set ...
           def_vtx[]    =    "No Name"; // ... for Directories/Folders or Volumes.



void Map_Print( Fl_Printer *, Image_REF *, int, int, int, int );



void UpdateGLWinVName( VolRef * ref )
// Global routine to update the volume name display one each realted window
// that diplay aslide of the specified volume.
// This routine is called each slide Volume Reanme.
//
{
  DiaViewer_GL     * w;
  int ii;

  for(ii = 0; ii < MAXIMUM_VIEW; ii++) {
    if (w = Viewer_GLT[ii]) {           // For each opened GL Window ...
      if (w->Curr_Vol == ref->volm) {   // ... that displays the same volume ...
        Viewer_UIT[ii]->w_title->value( ref->name );    // ... Update the displayed volume name.
      }
    }
  }
} // void UpdateGLWinVName( VolRef * ref ).



static void ViewVol( const char * t )
{
  int nvol  =    OpenVolTable.TabUse();
  VolEntry     ** VolList = (VolEntry**)OpenVolTable.GetObjs();
  VolEntry                       * vol;
  const char                    * name;

  printf( " LVol %s\n", t );
  for(int i=0; i<nvol; i++) {
    vol = VolList[i];
    name = vol->VName();
    printf( "      %d/ \"%s\" : \"%s\"\n", i, (name)? name : "<No Name>", vol->VRoot()->FName() );
    fflush( stdout );
  }
  printf( "/n" );
} // static void ViewVol();




void DiaViewer_GL::Init( int argc, char **argv, int nw, int iniflg )
// Routine (function) to initialize the DiaViewer_GL (FLTK) windowing system.
// nw is the window number (0 for the first one), and iniflg is the init call
// mode : 0 for a simple load a image, 1 for initial window load at start time,
// 2 for a load  image after a volume selection change (select/open or close volume).
// -(UInb+1) for a new window created from the current active window (Parent window).
{
  static int init   =       1; 
  DiaViewer_UI        *   win;
  char                * wname;

  // Allocate enough memory for window name change. 
  wname = new char[64];
  sprintf( wname, "DiaViewer Slide Window # %1d", nw+1 );

  // Get the size of the computer screen on the first call.
  if (init) {
    svargc = argc, svargv = argv;
    Fl::screen_xywh( screen_x, screen_y, screen_w, screen_h, screen_nb );
    init = 0;
//  printf( " Number of window to create = %d\n", WinVolume.size );
    ViewerNbWin = WinTable.size/4;   // Set the initial number of window (-1 for current).

    // Allocation for multiple window Displays.
    Viewer_UIT = new DiaViewer_UI *[MAXIMUM_VIEW];
    Viewer_GLT = new DiaViewer_GL *[MAXIMUM_VIEW];
    for(int i=0;i<MAXIMUM_VIEW;i++) {
      Viewer_UIT[i] = NULL;
      Viewer_GLT[i] = NULL;
    } 
    SliRefer::Init( MAXIMUM_VIEW );
    IniSelVolum = (VolEntry*)OpenVolTable.GetObj( WinTable.tab.i[0] );
  }

  // Create the user interface # nw.
  ViewerNumber = nw;

  // Create the window object.
  win = new DiaViewer_UI( 0, 0, 860, 715, wname );

  // Set the DiaViewer start time when required.
  win->w_image->Win_Start = iniflg;   // To children window creation, iniflg is parent -(# + 1).

//printf( " Window %d created\n", nw ); fflush( stdout );

  win->show( argc, argv );    // Display the first window.

  Viewer_UIT[nw]  =              win; // Keep the User Interface address in the display table.
  Viewer_GLT[nw]  =     win->w_image; // Keep the GL Display access.

//printf( " Window %d shown\n", nw ); fflush( stdout );

} // void DiaViewer::GL_Init( int argc, char **argv, int nw ).



//
// Class DiaViewer_GL methodes.
//

DiaViewer_GL::DiaViewer_GL( int x, int y, int w, int h, const char *title )
            : Fl_Gl_Window( x, y, w, h, title )
// This creator is called by the DiaViewer_UI creator(when create the GL window.
{
  Win_Init      =            1; // To force GL context init on the first call of draw() method.
  Win_UInb      = ViewerNumber, // Get the DiaViewer_Ui index in DiaViewer_GL class.
  Win_Start     =            0; // Default is not created at start time.

  w_widt   =  w; w_high   =  h; // Default GL windows as 24*36 ??? Landscape Diapositive, ...
                                // ... with a scale of ww/24 pixels/mm.
  // The initiale Diapositive is an empty diapositive (black).
  r_scale       =          1.0; // Just to initialize.
  ViewReady     =            0; // To force the GL and Viewer Initialisation.
  Curr_Map      =         NULL; // Initialize the current Pixel Map pointer.
  Curr_Vol      =  IniSelVolum; // Set the default current volume if defined.
  Curr_Sli      =  IniSelSlide; // No selected slide.
  W_Refer       =         NULL; // NO default slide reference.
} // DiaViewer_GL::DiaViewer_GL( int x, int y, int w, int h, const char *title ).



DiaViewer_GL::~DiaViewer_GL()
{
  if (W_seawin) {
    delete W_seawin; W_seawin = NULL;
  }
} // DiaViewer_GL::~DiaViewer_GL().




void DiaViewer_GL::New_View()
{
  int i;

  IniSelVolum = Curr_Vol;       // On its creation the new window display the ...
                                // ... same slide volume than its parent one's.
  for( i = 0; i < MAXIMUM_VIEW; i++) if (!Viewer_GLT[i]) break;
//printf( " split parm = %d\n", i ); fflush( stdout );
  if (i < MAXIMUM_VIEW) {
    SliEntry::CacheSplit( i );
    Init( svargc, svargv, i, -(1 + Win_UInb) );
  } else fl_alert( " You can open a maximum of %d slides's windows.", MAXIMUM_VIEW );
} // void DiaViewer_GL::New_View().



void DiaViewer_GL::Viewer_Init()
{
  Win_Init      =            0; // Do not recall it.

  // Get the DiaViewer Structure (class) adress.
  DiaViewer_UI *Uiw = Viewer_UIT[Win_UInb];
    
  // Keep the GL_display address for the new window.

  W_main        =  Uiw->w_main; // Pointer to the FLTK window, ...
  W_fdir        =    Uiw->fdir; // ... to first directory, ...
  W_pdir        =    Uiw->pdir; // ... to previous directory, ...
  W_fsli        =    Uiw->fsli; // ... to first slide, ...
  W_psli        =    Uiw->psli; // ... to previous slide, ...
  W_zoom        =    Uiw->zoom; // ... to the zoom slider, ...
  W_nsli        =    Uiw->nsli; // ... to next slide, ...
  W_lsli        =    Uiw->lsli; // ... to last slide, ...
  W_ndir        =    Uiw->ndir; // ... to next directory, ...
  W_ldir        =    Uiw->ldir; // ... and to last directory.

  W_xscroll   =  Uiw->x_scroll; // Pointer to t X and Y scroll bar, ...
  W_yscroll   =  Uiw->y_scroll;

  W_class       = Uiw->w_class; // ... to the classification button, ...
  W_path        =  Uiw->w_path; // ... to the Slide file path, ...
  W_text        =  Uiw->w_text; // ... and to the slide comment.

//W_slinbr    =  Uiw->w_slinbr; // Group to lock/unlock the slide numbers edition.
  W_sliid       = Uiw->w_sliid; // Slide Number.
  W_flmid       = Uiw->w_flmid; // Slide Number.
  W_parid       = Uiw->w_parid; // Slide Number.
  W_chpid       = Uiw->w_chpid; // Slide Number.
  W_lock        =  Uiw->w_lock; // To can change the lock button flag.
  W_ignor       = Uiw->w_ignor; // to clear and lock slide ranking data.
  W_autom       = Uiw->w_autom; // To can change the Auto Mode button flag.
  W_enrkg       = Uiw->w_enrkg; // To can change the rankind data button flag.
  W_title       = Uiw->w_title; // Slide anotation Text.

  W_seawin      =         NULL; // Init the Pointer to the search interface pointer.


  W_orient    =  Uiw->w_orient; // Orientation group.
  W_slcntx    =  Uiw->w_slcntx; // Context data group.
  W_brank     =   Uiw->w_brank; // Rankink group.
  W_iden        =    Uiw->iden; // Original orientation of slide.
  W_rp90        =    Uiw->rp90; // Slide rotation +90° (antcleari-clock wise).
  W_rm90        =    Uiw->rm90; // Slide rotation -90° (clock wise).
  W_r180        =    Uiw->r180; // Slide rotation of 180°.
  W_invx        =    Uiw->invx; // Slide mirror mx.
  W_invy        =    Uiw->invy; // Slide mirror my.
  W_invu        =    Uiw->invu; // Slide mirror mu.
  W_invv        =    Uiw->invv; // Slide mirror mv.
    
  W_Refer       =         NULL; // Pointer to current context reference.

  ViewerReady   =            0; // Set to Zero to force the load of first slide.
  ViewRkgFlgs   =            0; // Init Viewer flags.

  schp = spar = sflm = ssli= 0;// Initialize the search arguments.
  stxt          =         NULL;
} // DiaViewer_GL::Viewer_Init().



void DiaViewer_GL::SaveVolStatus()
{
  int flg   =  FlgVal()&Context_Viewer,
      wpc   =         Process->PrgPc(),
      wid   =         Process->PrgId();

  if ((flg != Curr_Vol->FlgVal())||(wpc != Curr_Vol->PrgPc())||
      (wid != Curr_Vol->PrgId())) {
    if (!(Curr_Vol->FlgTst( Context_MemImg ))) Curr_Vol->FlgVal( flg|Context_Update );
    Curr_Vol->PrgPc( this->Process->PrgPc() );
    Curr_Vol->PrgId( this->Process->PrgId() );
  }
} // void DiaViewer_GL::SaveVolStatus().



int  DiaViewer_GL::RkgEditEnDi( int bfl )
// Lock or unlock the Ranking data edition (when possible).
{
  DiaViewer_GL * WGl;

  if (Curr_Vol->FlgTst( Context_MemImg )) {
    bfl = 0; // We cannot edit/rank a memory volume.
    W_brank->deactivate();
    W_class->deactivate();
  } else {
    W_brank->activate();
    W_class->activate();
  }

  if (bfl) { // Check other windows : Only one window must be in Edit mode on the same volume.
    for (int i = 0; i < MAXIMUM_VIEW; i++) {
      if ((WGl = Viewer_GLT[i])&&(WGl != this)) {
        if ((Curr_Vol == WGl->Curr_Vol)&&(WGl->FlgTst( Context_RkgEdit ))) {
          fl_message(
                      "Not allowed :\n The DiaViewer windows #%d is in Edit ranking mode%s\n \"%s\".",
                      i+1, " on the same volume", Curr_Vol->VRoot()->FName() );
          bfl = 0;
        }
      }
    }
  }
  if (!bfl) { // To Disable Ranking data numbers edition.
    if (W_Refer) W_Refer->CheckSliCntx();// Save the Ranking context.);
    W_sliid->set_output();
    W_flmid->set_output();
    W_parid->set_output();
    W_chpid->set_output();
//  W_slinbr->set_output();
    FlgClr( Context_RkgEdit|Context_RkgAuto|Context_VnaEdit );
    W_enrkg->value( 0 );
    W_autom->value( 0 ); 
    W_orient->deactivate();
  } else { // To enable Ranking data numbers edition.
    if (W_Refer&&!W_Refer->FlgTst( Context_ProInb )) {
      W_sliid->clear_output();
      W_flmid->clear_output();
      W_parid->clear_output();
      W_chpid->clear_output();
    }
    if (W_Refer&&!W_Refer->FlgTst( Context_ProTxt )) W_text->clear_output();
    if (W_Refer&&!W_Refer->FlgTst( Context_ProOri )) W_orient->activate();
//  W_slinbr->clear_output();
    W_enrkg->value( 1 );
    FlgSet( Context_RkgEdit );
  }
  // Because no slide context change, we can use a simple redraw().
  W_slcntx->redraw();
  return FlgTst( Context_RkgEdit );
} // DiaViewer_GL::RkgEditEnDi( int fl ).



void DiaViewer_GL::InitStdScan( VolEntry * vol )
// Method to start the scan in Volume vol with its standard scan program. 
//
{
  SlideExec      * ppr;
  int        * wstparm;
  int        ie,   flg;
  char const    * vnam;

  if (vol) vnam = vol->VName();                 // Get the volume name when defined.

  if (Curr_Sli) W_Refer->CheckSliCntx();        // Save Slide context when existing.

  Curr_Vol = vol;                               // Set this volume as the current one.
  Program = (SlidePrg*)(Curr_Vol->RelPrg());    // Get the Volume scan programe.
  Process = new SlideExec( Curr_Vol,Program );  // Initialize the processor.
  ie = Process->Start( 0, SlidePrior );         // Start the program execution ...
                                                // ... that stop on the first slide.
//printf( " Inistd D\n" ); fflush( stdout );
  if (ie) {
    fl_alert( "Scan Program execution error %d.", ie );
    return;
  }

//printf( " Std : Win_Start = %d\n", Win_Start );
  switch (Win_Start) {
    case 1: // Start time window creation (get position from .DiaViewer.conf).
      if (WinTable.size) {
        wstparm = WinTable.tab.i + 4*Win_UInb; // Get the previous window parms.
        flg = wstparm[1]&Context_Viewer;
        if ((wstparm[2] < 0)||(wstparm[3] < 0))
          Process->SetPosition( Curr_Vol->PrgPc(), Curr_Vol->PrgId() );
        else
          Process->SetPosition( wstparm[2], wstparm[3] );
        Curr_Vol->WinSel();
      }
    break;

    case 2: // Load position from the Volume context (for open/select volume).
//    printf( " Std : flg %d, pc %d, id %d\n", Curr_Vol->FlgTst(  Context_Viewer ), Curr_Vol->PrgPc(), Curr_Vol->PrgId() );
      flg = Curr_Vol->FlgTst(  Context_Viewer );
      Process->SetPosition( Curr_Vol->PrgPc(), Curr_Vol->PrgId() );
      Curr_Vol->WinSel();
    break;

    case 0: // Just reload a new image or modified image.
      flg = FlgVal();
    break;

  default: // Win_Start < 0 : Get position from the parent Viewer window (Parent w # = -1-Win_Start).
//printf( " Create children window # %d from Window %d\n",  Win_UInb, -1-Win_Start );
//fflush( stdout );
    flg = 0;
    Curr_Vol->WinSel();
    ppr = Viewer_GLT[-(1+Win_Start)]->Process;
//  printf( " AAA\n" ); fflush( stdout );
    Process->SetPosition( ppr->PrgPc(), ppr->PrgId() );
//  printf( " AAB\n" ); fflush( stdout );
  break;
  }
  Win_Start = 0;

//printf( " Std X : vflg = %d\n", W_autom->value() );

  FlgVal( flg&Context_Viewer );
  W_autom->value( (flg&Context_RkgAuto)? 1: 0 );

  Curr_Dir = Process->CurrDir();              // Get the directory and the slide.
  Curr_Sli = Process->CurrSli();

  RkgEditEnDi( FlgTst( Context_RkgEdit ) );

  if (vnam) W_title->value( vnam );           // To display the volume name.
       else W_title->value( 0 );

//Curr_Sli->SliRkgClear();
//printf( " Vol %d, Dir %d, Sli %d\n", Curr_Vol?1:0, Curr_Dir?1:0, Curr_Sli?1:0 );
//printf( " InitStdScan done for %d\n", Win_UInb ); fflush( stdout );

} // void DiaViewer_GL::InitStdScan( VolEntry * vol ).



void DiaViewer_GL::DefSetRkgNbr( int cat )
//
// Performs the slide automatic setting when enable.
//
{
  int nb, fl, fs, s, f, p, c;

//printf( " DefSetRkgNbr %d\n", cat );
  W_Refer->RefRkgGet( s, f, p, c );
  fl = FlgTst( Context_RkgAuto );
  fs = FlgTst( Context_ChNoLnk );
  switch(cat) {
    case 3: // Chapter # change
      nb = W_chpid->value();
      if (fl&&(nb-1 == c)) {
        p = 1;
        if (!fs) f = s = 1;
      }
      if (fl&&(nb-1 == c)) p = f = s = 1;
      c = nb;
    break;
    case 2: // Paragraph # change
      nb = W_parid->value();
      if (fl) {
        if (nb-1 == p && !fs) f = s = 1;
        if (!c) c = 1;
      }
      p = nb;
    break;
    case 1: // Film # change
      nb = W_flmid->value();
      if (fl) {
        if (nb-1 == f) s = 1;
        if (!(p||c)) p = c = 1;
      }
      f = nb;
      break;
    case 0: // Slide # change.
      nb = W_sliid->value();
      if (fl&&!(s||f||p||c)) f = p = c = 1;
      s = nb;
    break;
  }
  W_Refer->RefRkgSet( s, f, p, c );
  W_Refer->RefRkgUpdDisp(s, f, p, c); // Update all same slide displays.
} // void DiaViewer_GL::DefSetRkgNbr( int cat ).



void DiaViewer_GL::RkgCntxClear( int fd )
// Clear all ranking number of the current slide ,(fd = 0) ...
// ... or all slides of the current directory (fd = 1).
//
{
  W_Refer->RefRkgClr();         // Delete memory of previous slide.
  if (fd||!Curr_Sli->FlgTst( Context_ProInb )) {
    FlgClr( Context_RkgAuto );  // Deactivate the Auto Mode to preserve the RkgCntxClear() result(s).
    W_autom->value( 0 );
  }
  if (FlgTst( Context_RkgEdit )&&Curr_Sli) {
    Curr_Sli->SliRkgClear();
    if (fd) Curr_Dir->RkgClear();
       else Curr_Sli->RkgClear();
  }
  ShowSlide( 0 );
} // void DiaViewer_GL::RkgCntxClear( int fd ).



void DiaViewer_GL::RkgCntxProtect( int pty, int flg, int fset )
{
  int fla;

  if (pty&1) fla  = Context_ProInb;
  if (pty&2) fla |= Context_ProTxt;
  if (pty&4) fla |= Context_ProOri;
  if (pty&8) fla |= Context_LckRank;

  if (fla&Context_ProInb)
    if (flg) {
      W_sliid->set_output();
      W_flmid->set_output();
      W_parid->set_output();
      W_chpid->set_output();
    } else {
      W_sliid->clear_output();
      W_flmid->clear_output();
      W_parid->clear_output();
      W_chpid->clear_output();
    }

  if (fla&Context_ProTxt)
    if (flg) ; //W_Text->set_output();
        else W_text->clear_output();
  if (fla&Context_ProOri)
    if (flg) ; //W_orient->set_output();
        else W_orient->clear_output();

  if (!fset) W_Refer->RefRkgGet( Curr_Sli );
  if (flg) W_Refer->FlgSet( fla ); else W_Refer->FlgClr( fla );
  W_Refer->CheckSliCntx();
  if (Curr_Sli->FlgTst( Context_ProInb )) {
    W_lock->value( 1 );
  } else {
    W_lock->value( 0 );
  }
  W_slcntx->redraw();
  ShowSlide( 0 );
} // void DiaViewer_GL::RkgCntxProtect( int pty, int flg ).



void DiaViewer_GL::RkgCntxZero()
{
  Curr_Sli->SliRkgClear();
  W_Refer->RefRkgClr();
  W_Refer->FlgVal( Curr_Sli->FlgVal() );
  RkgCntxProtect( 7, 1, 1 );
} // void DiaViewer_GL::RkgCntxZero().



void DiaViewer_GL::SetSliProtect()
{
//printf( " Sli prot = %d, Win Edit = %d\n",
// Curr_Sli->FlgTst( Context_ProInb ), FlgTst( Context_RkgEdit) );
        
  if (Curr_Sli->FlgTst( Context_ProInb )||(!FlgTst( Context_RkgEdit))) {
    W_sliid->set_output();
    W_flmid->set_output();
    W_parid->set_output();
    W_chpid->set_output();
//  W_slinbr->set_output();
    W_lock->value( Curr_Sli->FlgTst( Context_ProInb )? 1: 0 );
  } else {
    W_sliid->clear_output();
    W_flmid->clear_output();
    W_parid->clear_output();
    W_chpid->clear_output();
//  W_slinbr->clear_output();
    W_lock->value( 0 );
  }

  if (FlgTst( Context_RkgEdit )) {
    if (Curr_Sli->FlgTst( Context_ProTxt )) W_text->set_output();
                                       else W_text->clear_output();
    if (Curr_Sli->FlgTst( Context_ProOri )) W_orient->deactivate();
                                       else W_orient->activate();
  } else {
    W_text->set_output();
    W_orient->deactivate();
  }
} // DiaViewer_GL::SetSliProtect().



SliEntry * SMem = NULL;

void OutMemsta( const char * s )
// Routine of GL module to check test for debug.
{
  if (SMem) {
    printf( " %s Mem Sta Sli : %x ", s, SMem ); fflush( stdout );
    printf( ", %x\n", SMem->FlgTst( Context_MemImg ) ); fflush( stdout );
  }
} ///



void DiaViewer_GL::ShowSlide( int init )
//
// **** Routine to make visible the Current Slide ****
//
{
  char      mpath[268];
  int   ie, s, f, b, c;

//printf( " Try To load file \"%s/%s\n", Process->CurrPath(), Curr_Sli->FName() );

  if (Curr_Sli) {

    if (!SMem&&Curr_Sli->FlgTst( Context_MemImg )) {
        SMem = Curr_Sli;
    }

//OutMemsta( "ShowSlide" );
    if (Curr_Sli->FlgTst( Context_MemImg )) {
      W_path->value( "<Internal DiaVeiwer Memory>" );
      Curr_Map = Curr_Sli->Get( Curr_Sli->FName(), Win_UInb, Curr_Sli->FlgTst( Context_MemImg ) );
    } else {
       snprintf( SliPath, 255, "%s%s", Process->CurrPath(), Curr_Sli->FName() );
      snprintf( mpath, 267, "Path = \"%s\"", SliPath );
      Curr_Map = Curr_Sli->Get( SliPath, Win_UInb, Curr_Sli->FlgTst( Context_MemImg ) );
      W_path->value( mpath );               // Edit the window file reference.
    }

    if (Curr_Map) {   // We have loaded the Slide in the Image Cache.
      i_widt  = Curr_Sli->W();
      i_high  = Curr_Sli->H();
      i_pixs  = Curr_Sli->P();

      i_shww  = i_hwid = i_widt/2;
      i_shhh  = i_hhig = i_high/2;
      i_cenx  = i_ceny = 0.0;               // Set the default center of display in the image.
      img_x1  = -(img_x2 = i_hwid);         // Set the image (PixMap) limits.
      img_y1  = -(img_y2 = i_hhig);
      FirstView = 1;

      // Display all context values.

// printf( "\n Sh Sl: AM\n" ); fflush( stdout );
// printf( " Showsli A : vflg = %d\n", W_autom->value() );
      W_Refer = SliRefer::LookMultipl( Curr_Sli, Win_UInb );  // Get/Set the slide reference.
//printf( " Showsli B : vflg = %d\n", W_autom->value() );

      // When the ranking data are locked (protected) ...
      SetSliProtect();
      W_Refer->RefRkgGet( s, f, b, c );     // Get Ranking numbers from current slide.
      if (FlgTst( Context_RkgAuto )&&       // When auto rank is enable, ...
          W_Refer->RefRkgTZero()&&          // ... the slide rank numbers are null (& not protected), ...
          Process->PrvRkgTest()) {          // ... and the previous numbers are valid then ...
        Process->PrvRkgGet( s,f,b,c );      // ... we get the previous ones, ...
        if (s < slin_max) s++;              // ... increment the slide number and ...
          W_Refer->RefRkgSet(s, f, b, c);   // ... set it in the slide reference block.
      }

      W_Refer->RefRkgUpdDisp(s, f, b, c);   // Update all same slide displays.

      // To display the slide comment (in future).
      if (!init ) redraw();
    } else {
      ie = Curr_Sli->E();
      fl_alert( "DiaViewer : Cannot load the slide \"%s\"\n with error %d .",
                Curr_Sli->FName(), -ie );
    }
  }
  else
    W_path->value( "  << NO Image ! >>" );
} // void DiaViewer_GL::ShowSlide( int init ).



void DiaViewer_GL::RkgAutoMode( int flg )
{
  if (flg) {
    if (FlgTst( Context_RkgEdit )) FlgSet( Context_RkgAuto );
                              else W_autom->value( 0 );
  } else FlgClr( Context_RkgAuto );
// printf( " W Flg = %d\n", FlgVal() );
} // void DiaViewer::RkgAutoMode( int flg ).



void DiaViewer_GL::VNameEditMode( int flg )
{
  if (flg) {
    W_title->clear_output();
    W_title->textcolor( FL_FOREGROUND_COLOR );
  } else {
    FlgClr( Context_VnaEdit );
    W_title->set_output();
    W_title->textcolor( FL_RED );
  }
  W_title->redraw();
} // void DiaViewer_GL::VNameEditMode( int flg ).




void DiaViewer_GL::NormalEnd( int flg = 0 )
{
  VolEntry   **VolList;
  VolEntry       * Vol;
  DiaViewer_GL   * WGl;
  int       nvol, nsel;
  int         wnb  = 0;
  int    nvl, wni, idx;

  // Get the count of really used GL Windows.
  for(int i = 0; i < MAXIMUM_VIEW; i++) if (Viewer_GLT[i]) wnb++;

  if ((wnb>1)&&(flg==0)) {
    // When other views are opened, we just close the present one.
    Viewer_UIT[Win_UInb] = NULL;
    Viewer_GLT[Win_UInb] = NULL;
    W_Refer->CheckSliCntx();            // Save the Ranking context.
    W_Refer->RefFree( Win_UInb );       // Free the attached slide reference.
    SliEntry::CacheMerge( Win_UInb );
    Curr_Vol->WinUnSel();               // Decrement the volume attached window count.
    delete W_main;
  } else {
    // Here is the process to terminate DiaViewer execution ...
    // ... and save the global and volume specific contexts.
    nvl     = OpenVolTable.TabUse();
    VolList = (VolEntry**)OpenVolTable.GetObjs();
    idx = 0; nvol = nvl;
    while (idx < nvol) if (VolList[idx++]->FlgTst( Context_VDiRam|Context_VDiRam )) nvol--;

    VolToOpen.size = nvol;
    if (nvol) {
      VolToOpen.tab.i = new int[nvol];
      idx =  0;
      for(int k = 0; k < nvl; k++) {    // Fill the Volume path to open table.
        if (!(VolList[k]->FlgTst( Context_MemImg|Context_VDiRam )))
          VolToOpen.tab.i[idx++] = VolList[k]->VRefer()->iide;
      }
    } else VolToOpen.tab.s = NULL;

    // Destroye any old Windows table and create a new one.
    if (WinTable.size > 0) delete[] WinTable.tab.i;

    // ... and create new ones.
    // For each window, the table keep the associated volume number, ...
    // ... the window status, and the window position in the volume (4 int).
    WinTable.size = 4*wnb;
    WinTable.tab.i = new int[4*wnb];

    nsel = 0;
    int tsel = 0;                               // Temporary.
    for(int i = 0; i < MAXIMUM_VIEW; i++) {     // Loop on all possible windows.
      if (Viewer_UIT[i]) {                      // When this windows # is used.
        WGl = Viewer_GLT[i];                    // We get the DiaViewer_GL object.
        if (WGl->W_Refer)                       // We force to save volume ...
          WGl->W_Refer->CheckSliCntx();         // ... Ranking context.
        for(int j = 0; j < nvl; j++) {
          if (VolList[j] == WGl->Curr_Vol) {    // When the volume is find ...
            WinTable.tab.i[nsel++] = j;         // Set the volume # to select, ...
            WinTable.tab.i[nsel++] = WGl->FlgTst( Context_Viewer ); // ... flags, ...
            WinTable.tab.i[nsel++] = WGl->Process->PrgPc();     // ... Set pc, ...
            WinTable.tab.i[nsel++] = WGl->Process->PrgId();     // ... and the slide index.
          }
        }
      }
    }
    // We must save all volume contexts before exit.
    for(int j = 0; j < nvl; j++) {
      Vol = VolList[j];
      if (Vol->FlgTst( Context_MemImg|Context_VDiRam| Context_Update) == Context_Update)
          Vol->WriteVolContext();
    }
    SaveAllApplContext( Curr_Vol );
    exit( 0 );
  }
} // void DiaViewer_GL::NormalEnd( int flg = 0 ).



void DiaViewer_GL::SetSize( int ww, int hh )
// Force the size (arguments in GL space).
{
    
} // void DiaViewer_GL::SetSize( int ww, int hh ).



void DiaViewer_GL::VolClose()
// To close and free all structures of a Slide volume.
{
#ifdef GL_DEBUG
    static const char dnam[]="<noname>";
#endif

    int  svc, svl, rvl,
            iln,  nvol;
    VolRef      * vref;
    VolEntry    * rvol, // rvol is the replacement volume to select in place of volume to close.
                * cvol, // cvol is the volume to close.
            ** VolList; // Table of actually opened volumes (int the OpenVolTable table).
    DiaViewer_GL   * w; // A pointer of window view.

    nvol = OpenVolTable.TabUse();               // Get the number of open volume.

    // Get the list of all opened volumes.
    VolList=(VolEntry**)OpenVolTable.GetObjs(); // Get the list of all opened volumes.

    vref = VolMN_Ref( "Select the Volume to close in this list", VolMnf_Opened );

//printf( " Close : Idx = %d, path=%s\n", ivl, cvol->VRoot()->FName() ); fflush( stdout );

    if (!vref) return;

    cvol = vref->volm;

    // Look for a volume to replace the volume to close for any windows.

    svl = 0;                                    // Loop to get the index of selected volume.
    while (svl < nvol && VolList[++svl] != cvol) ;

    // Now svl in range [1..nvol-1] is t   he index of volume to close.
    if (svl > 1)                                // By default the replacement volume should  be ...
        rvl = svl - 1;                          // ... the previous one, ...
    else {                                      // ... but if it was the second one, ...
        rvl = svl + 1;                          // ... it is better to take the next one, ...
        if (rvl >= nvol) rvl = 0;               // ... except when this next does not exist, ...
                                                // ... then we take the first memory volume.
    }
    rvol = VolList[rvl];                        // Get the replacement volume address.

    svc = 1;                                    // Set flag to save the volume ranking context.
    // Loop to change Volume for all slides's window using the volume to close.
    for(int i=0; i<MAXIMUM_VIEW; i++) {         // Loop on all opened slides view.
        w = Viewer_GLT[i];                      // Skip Not opened View and ...
//      printf( " Close : B%d, %d\n", i, w!=0 ); fflush( stdout );
        if (w&&(w->Curr_Vol == cvol)) {         // ... select only the view(s) of the closed volume.
//          printf( " Close : BA, %d, %d\n", i, w->Curr_Vol!=0 ); fflush( stdout );
            if (cvol->WinUnSel()) {             // Decrement the number of Wiew that display this volume ...
                                                // ... and save its context when it is the last ref.
//              printf( " Close : BB, %d, %d\n", i, w->Curr_Vol!=0 ); fflush( stdout );
                w->SaveVolStatus();             // ... Save the last window status in the volume status.
            }
//          printf( " Close : BC, %d, %d\n", i, w->Curr_Vol!=0 ); fflush( stdout );
            if (svc&&FlgTst( Context_RkgEdit )) {
                svc = 0;
                w->W_Refer->CheckSliCntx();     // Save the Ranking context if not already done.
            }
//          printf( " Close : C w# = %d, ClVol=%s\n", i, (rvol)? rvol->VRoot()->FName() : "<Null>" );
            if (rvol) {                         // Select the replacement volume if it is existing.
                Win_Start = 2;                  // For change of volume.
                w->InitStdScan( rvol );
                w->ShowSlide( 0 );
            } else {                            // Sorry, but no slide volume => ...
                w->Curr_Vol = NULL;             // ... => black window.
                w->Curr_Sli = NULL;
                w->W_Refer  = NULL;
                w->redraw();
            }
        }
    }

    // Save (update when required) the context files of the voume to close ...
    if (cvol) {
        cvol->WriteVolContext();
        delete cvol;                            // ... and Destroye all volume locations.
    }
} // void DiaViewer_GL::VolClose().



void DiaViewer_GL::VolOpen()
// Open a directory and scan it.
// A New Slide volume is created.
//
{
  int        idv, ll;
  char       *  fnam;
  VolRef     *   ref;
  VolEntry   *   vol;

  // Select a defined (known) slide volume.
  ref = VolMN_Ref( "DiaViewer: Selecte Slide Directory to open", VolMnf_ToOpen );

  if(!ref) return;
  if (ref->volm) {
      fl_alert( "The slides volume \'%s\' is already open.", ref->name );
      return;
  }

  idv = CreateVolumeTree( ref );
  if (idv < 0) return;

//printf( " E X\n" ); fflush( stdout );
  if (W_Refer) {
    W_Refer->CheckSliCntx();        // Save the Ranking context.
    W_Refer  = NULL;
    Curr_Sli = NULL;
  }
//printf( " E X1\n" ); fflush( stdout );
  // We must save the volume status of the previous volume displayed on ...
  // ... the current window if it was unique.
  if (Curr_Vol&&(Curr_Vol->WinUnSel())) SaveVolStatus();

//printf( " E Y %d / %d\n", idv, OpenVolTable.TabUse() ); fflush( stdout );
  Curr_Vol = (VolEntry*)OpenVolTable.GetObj( idv-1 );
//printf( " F Z\n" ); fflush( stdout );

  Win_Start =  2;                     // For Change of volume.
  InitStdScan( Curr_Vol );
  ShowSlide( 0 );
}  // void DiaViewer_GL::VolOpen.



void DiaViewer_GL::VolSelect()
// To change of slide volume.
{
    VolRef      * vref;
    int       idv =    0;
    VolEntry *vol = NULL;
    const char    * vnam;

    if (OpenVolTable.TabUse() < 2) return;  // Nothing to do.

    vref = VolMN_Ref( "Select the Volume to select in this list", VolMnf_SOpened );

//  idv = SlideVolSelect(  "Select a Volume in this list", vol );


#ifdef GL_DEBUG
    printf( " Volume # %3d : %s Path=\"%s\"\n", idx, vnam, vol->VRoot()->FName() );
#endif

    if (W_Refer) {
      W_Refer->CheckSliCntx(); // Save the Ranking context.
      W_Refer  = NULL;
      Curr_Sli = NULL;
    }

    if (Curr_Vol) {
      SaveVolStatus();

      if (!svol1) svol1 = Curr_Vol;
             else if (!svol2) svol2 = Curr_Vol;
      if (!(Curr_Vol->FlgTst( Context_MemImg )))
        if (Curr_Vol->FlgTst( Context_Update )) Curr_Vol->WriteVolContext();
    }

    Win_Start = 2;
    InitStdScan( vref->volm );
    ShowSlide( 0 );
} // void DiaViewer_GL::VolSelect().



void DiaViewer_GL::SaveContext()
{
  if (W_Refer) {
    W_Refer->CheckSliCntx();    // Save the Ranking context.
    Curr_Vol->WriteVolContext();
    }
} // void DiaViewer_GL::SaveContext().



void DiaViewer_GL::DirScan( int chs )
// Change of slide directory in the same volume.
{
  int ier;

  if (!Curr_Vol) return;
  if (Curr_Sli) W_Refer->CheckSliCntx(); // Save the Ranking context.
  ier = Process->Continue( chs, SlidePrior );
//printf( " DirScan ier = %d\n", ier );
  if (ier >= 0) {
    Curr_Dir = Process->CurrDir();  // Get the directory and the slide.
    Curr_Sli = Process->CurrSli();
    ShowSlide( 0 );
  }
} // void DiaViewer_GL::DirScan( int chs ).



void DiaViewer_GL::SliScan( int id )
// To manage the scan inside a slide directory.
// id values and effect.
//  n > 0 to skip to the n'th slide of current directory,
//  0 to skip to the next slide,
// -1 to skip to the previous slide,
// -2 to skip to the last slide of current directory.
//
{
  int ie;

  if (!Curr_Vol) return;
  if (Curr_Sli) W_Refer->CheckSliCntx();// Save the Ranking context.
  ie = Process->SlideScan( id );        // We operate in an existing directory.
  if (!ie) {                            // We operate in an existing directory.
    Curr_Sli = Process->CurrSli();
    ShowSlide( 0 );
  } else {
    if ((ie > 0)&&ScanNoLim&&           // Stop on directory limits and ...
    (id == 0||id == -1)) DirScan( id ); // it is single step request ...
                                        // ... We skip to next/previous directory.
  }
} // void DiaViewer_GL::SliScan( int id ).



void DiaViewer_GL::DirRestart( int chs )
// Restart to first(chs<0) or last(chs>=0) slide in the volume..
{
    int id = (chs<0)? 1 : -1;

  if (!Curr_Vol) return;
  if (Curr_Sli) W_Refer->CheckSliCntx();// Save the Ranking context.
  if (Process->Start( id, SlidePrior ) >= 0) {
    Curr_Dir = Process->CurrDir();      // Get the directory and the slide.
    Curr_Sli = Process->CurrSli();
    ShowSlide( 0 );
  }
} // void DiaViewer_GL::DirRestart( int chs ).


//
// Specials global search slide functions.
//

void DiaViewer_GL::Search_Init( int iflm, int isli )
// When isli and iflm are note zero they are set for the search.
{
  char title[64];

  // Set film and/or slide number when specified.
  if (iflm) sflm = iflm;
  if (isli) ssli = isli;
  schp = spar = 0;

  if (W_seawin) {
    W_seawin->SetArgs( schp, spar, sflm, ssli, stxt );
  } else {
    snprintf( title, 63, "Slide Search for View Window # %d", Win_UInb + 1 );
    W_seawin = new SliSearch( title, this );
    W_seawin->SetArgs( schp, spar, sflm, ssli, stxt );
    W_seawin->s_msg->value( "" );
    W_seawin->s_loop->value( (FlgTst( Context_SeaLoop ))? 1 : 0 );
    W_seawin->Show( svargc, svargv );
  }
} // void DiaViewer_GL::Search_Init( int iflm, int isli ).



void DiaViewer_GL::Search_Process( int  id )
// Perform a search sequence :
// id = +1/-1 for search direction.
//
{
  int      ier = 0;
  const char * str;

  if (W_seawin) {
    W_seawin->GetArgs( schp, spar, sflm, ssli, str );
//printf( " Search parm : %d, %d, %d, %d\n", schp, spar, sflm, ssli );

    if (Curr_Sli) W_Refer->CheckSliCntx();  // Save the Ranking context.

    if (stxt) delete[] stxt; stxt = strdup( str );
    ier = Process->Search( id, schp, spar, sflm, ssli, stxt, FlgTst( Context_SeaLoop ) );
    Curr_Dir = Process->CurrDir();          // Get the directory and the slide.
    Curr_Sli = Process->CurrSli();
    if (ier)
      W_seawin->s_msg->value( "Slide not found" );
    else if (Process->LoopFlg())
      W_seawin->s_msg->value( "Search Loop" );
    else W_seawin->s_msg->value( "" );
    
//  RkgClearCntx();
    ShowSlide( 0 );
  }
} // void SlideExec::Search_Process( int  id ).



void DiaViewer_GL::Search_Exit( int  fl )
// finish a search. fl == 0 to stay on the founded slide.
//                  fl != 0 to return to initial slide.
{
  if (W_seawin) {
    if (Curr_Sli) W_Refer->CheckSliCntx();  // Save the Ranking context.
    Process->SearchRestore( fl );           // Clear search origine memory and ...
                                            // ... Return to Original slide if fl.
    if (fl) {
      Curr_Dir = Process->CurrDir();        // Get the directory and the slide.
      Curr_Sli = Process->CurrSli();
//    RkgClearCntx();
      ShowSlide( 0 );
    }
  }
  W_seawin->CloseSearch();
  W_seawin = NULL;
} // void DiaViewer_GL::Search_Exit( int fl ).




//
// Slide rotate function.
//

void DiaViewer_GL::SliTransf( Image_REF::Image_Trf trf )
// Modify by rotation or mirror the selected Slide.
{
  DiaViewer_GL * w;

  if (Curr_Sli) W_Refer->CheckSliCntx(); // Save the Ranking context.
  int t = Curr_Sli->Transform( trf, SliPath, Win_UInb );
  switch (t) {
    case 0: Curr_Sli->FlgClr( Context_Orient );
    break;
    case 1: Curr_Sli->FlgSet( Context_Orient );
    break;
    case 2: { Curr_Sli->FlgSet( Context_Update ); Curr_Sli->FlgClr( Context_Orient ); }
    break;
    case 3: Curr_Sli->FlgSet( Context_Orient|Context_Update );
    break;
  }
  // Now we must perform a redraw on each display.
  for (int i = 0; i < MAXIMUM_VIEW; i++ ) {
    if (w = Viewer_GLT[i]) {
      if (w->Curr_Sli == Curr_Sli) w->ShowSlide( 0 );
    }
  }
} // void DiaViewer_GL::SliTransf( Image_REF::Image_Trf trf ).



void DiaViewer_GL::XScroll()
{
  GLint vl;

  vl = W_xscroll->value();

  if (vl >= 0 && vl < i_widt - i_npix) {
//      printf( " X Scroll val = %d\n", vl  );
    X_shift += vl - i_spix;
    redraw();
  }
} // void DiaViewer_GL::XScroll().



void DiaViewer_GL::YScroll()
{
  GLint vl, sz;

  sz = i_high - i_nrow;
  vl = sz - W_yscroll->value();
  if (vl >= 0 && vl < sz) {
//      printf( " Y Scroll val = %d\n", vl );
    Y_shift += vl - i_srow;
    redraw();
  }
} // void DiaViewer_GL::YScroll().



void DiaViewer_GL::SetScale( float val )
{
//  printf( " Scale Value = %8.4f\n", val );
  i_shww = w_hwid/val; i_shhh = w_hhig/val;
  r_scale = val;
  SetScaVal = 1;
  redraw();
} // DiaViewer_GL::SetScale( float val ).


void DiaViewer_GL::UnZoom( int fl )
{
  i_shww = i_hwid;
  i_shhh = i_hhig;
  i_pixs = i_pixs;
  i_cenx = i_ceny = 0;
  FirstView = 1;
  redraw();
} // void DiaViewer_GL::UnZoom( int fl ).


void DiaViewer_GL::SliPrint()
// Print the current View of Diapositive.
{
  Fl_Printer printer;
  int width, height;
  float  fw,     fh;

  if (printer.start_job(1)) return;
  printer.start_page();
  printer.printable_rect( &width, &height );

  if (PrtFromGL) {
    fw = w_widt / float( width );
    fh = w_high / float( height );
    if (fh > fw) fw = fh;
    printer.scale( 1/fw );
    printer.print_widget( this );
  } else {
    fw = i_npix / float( width );
    fh = i_nrow / float( height );
    if (fh > fw) fw  = fh;
    printer.scale( 1.0/fw);
    Map_Print( &printer, Curr_Sli, i_spix, i_srow, i_npix, i_nrow );
  }

  printer.end_page();
  printer.end_job();
} // void DiaViewer_GL::SliPrint().




//
// Private methods.
//

void DiaViewer_GL::MouseDown( int x, int y, int button )
{
  if (!MouseStat) {     // When the mouse is active without button already pushed.
    zre_x1 = x, zre_y1 = y;
    zre_x2 = x, zre_y2 = y;
    fl_cursor( FL_CURSOR_CROSS );
    UsedButton = button;
    MouseStat = 1;
  }
} // void DiaViewer_GL::MouseDown( int x, int y, int button ).



void DiaViewer_GL::MouseDrag( int x, int y, int button )
{
  if (UsedButton!=button) {
    MouseStat = 0; return;
  }
  if ((x!=zre_x2)||(y!=zre_y2)) {
    zre_x2 = x; zre_y2 = y;
    redraw();
  }
} // void DiaViewer_GL::MouseDrag( int x, int y, int button ).



void DiaViewer_GL::MouseUp( int x, int y, int button )
{
  GLfloat zw, zh;

  if (UsedButton!=button) {
    MouseStat = 0; return;
  }
  zre_x2 = x; zre_y2 = y;
  fl_cursor( FL_CURSOR_DEFAULT );
  MouseStat = 0;

  zw = 0.5*abs( zre_x2 - zre_x1 ); zh = 0.5*abs( zre_y2 - zre_y1 );
  if ((zw > 50.0)&&(zh > 50.0)) {
    // Increase one rectangle size to fit with window proportions.
    if (zh*w_hwid > w_hhig*zw) zw = (zh*w_hwid)/w_hhig;
                          else zh = (zw*w_hhig)/w_hwid;
    // Get the showed view center translation vector (or new center coord.) ...
    // ... in the image coordinates.
    i_zcex = round( 0.5*(zre_x1 + zre_x2) ) /* + i_cenx */;
    i_zcey = round( 0.5*(zre_y1 + zre_y2) ) /* + i_ceny */;
    i_zshw = round( zw ); i_zshh = round( zh );

#ifdef GL_DEBUG
    printf( " SCALE = %f\n", r_scale );
    printf( " Z rect : x1=%d, y1=%d, x2=%d, y2=%d\n", zre_x1, zre_y1, zre_x2, zre_y2 );
    printf( " Center at (%d, %d)\n", i_zcex, i_zcey );
#endif

    ZoomStatus = 1;
  }
  redraw();
} // void DiaViewer_GL::MouseUp( int x, int y, int button ).



void DiaViewer_GL::XYinImage( int &x, int &y )
// Get the pointed coordinate in the image pixels space.
{
  x = round( (Fl::event_x() - w_hwid)/r_scale ) + i_cenx;
  y = round( (w_hhig - Fl::event_y())/r_scale ) + i_ceny;
} // void DiaViewer_GL::XYinImage( int &x, int &y ).



int  DiaViewer_GL::handle( int evn )
// Call to manage the mouse or keybord events.
//
{
  int     mx, my;
  int         bt;

  bt = Fl::event_button();
  switch (evn) {
    case FL_PUSH:
      XYinImage( mx, my );
      MouseDown( mx, my, bt );
      return 1;
    break;

    case FL_DRAG:
      XYinImage( mx, my );
      MouseDrag( mx, my, bt );
      return 1; redraw();
    break;

    case FL_RELEASE:
      XYinImage( mx, my );
      MouseUp( mx, my, bt );
      return 1;
    break;
        
//  case FL_MOUSEWHEEL:
//           
//  break;
        
    default: ;
  }
  return Fl_Gl_Window::handle( evn );
}  // int  DiaViewer_GL::handle( int evn ).




void DiaViewer_GL::draw()
// called to re-draw the GL window.
//
{
  GLint    whwid,        whhig, // Half display size in image pixels.
           map_x,        map_y; // PixelMap origine on Display.
  GLenum                maptyp;
  GLfloat   rx_scale, ry_scale;

  if (Win_Init) Viewer_Init();

#ifndef MESA
  glDrawBuffer(GL_FRONT_AND_BACK);
#endif // !MESA

  if (!valid()) {               // GL Init is done.
    w_widt  =          w(); w_high  =          h();
    w_hwid  =     w_widt/2; w_hhig  =     w_high/2;
    // Set the display pixel origine on the GL Window center in a 3D space.
    // glOrtho( (GLfloat)-w_hwid, (GLfloat)w_hwid, (GLfloat)-whhig, (GLfloat)w_hhig, -20.0, 20.0 );
    valid( 1 );
  }
//printf( " For w # %d, VR %d\n", Win_UInb, ViewReady ); fflush( stdout );

  if (!ViewReady) { // This sequence is executed only during a window_GL creation.
    ViewReady  = 1;
    if (Curr_Vol) InitStdScan( Curr_Vol );
    if (Curr_Sli&&Curr_Dir) ShowSlide( 1 );
    if (Win_UInb == 0) {
      for(int iw = 1; iw < ViewerNbWin; iw++) {
//      printf( " For win %d\n", iw );
        IniSelVolum = (VolEntry*)OpenVolTable.GetObj( WinTable.tab.i[4*iw] );
        SliEntry::CacheSplit( iw );
        Init( svargc, svargv, iw, 1 );
      }
    }
  }

//printf( " Draw Process\n" ); fflush( stdout );

  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
//printf( "Clear: map %d, mouseSt %d\n", Curr_Map!=0, MouseStat ); fflush( stdout );
  if (Curr_Map) {
        
//  Already done by ShowSlide().
//  i_shww = i_hwid = (i_widt = Curr_Sli->W())/2;
//  i_shhh = i_hhig = (i_high = Curr_Sli->H())/2;
//  ii_pxs = Curr_Sli->P();

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " Half Window sizes (screen pixels) : %d, %d\n", w_hwid, w_hhig );
      printf( " Half image sizes  (image  pixels) : %d, %d\n", i_hwid, i_hhig );
      fflush( stdout );
    }
#endif

    if (ZoomStatus) {
      // Test validity of the zoom.
      if (i_zcex-i_zshw < i_hwid && i_zcex+i_zshw > -i_hwid &&
          i_zcey-i_zshh < i_hhig && i_zcey+i_zshh > -i_hhig) {
        // Update the center of showed rectangle in image coordinates.

#ifdef GL_DEBUG             
        printf( " Zoom Half showed sizes (image  pixels) : %d, %d\n", i_zshw, i_zshh );
        printf( " Zoom Center of showed zoom (image  pixels) : %d, %d\n", i_zcex, i_zcey );
        fflush( stdout );
#endif

        FirstView = 0;
        if ((GLfloat)w_hwid/i_zshw <= 5.0 || (GLfloat)w_hhig/i_zshh <= 5.0)
        { // Limit the scale at 5.0 (5 Screen_Pixel/Image_Pixel)
          i_cenx = i_zcex; i_ceny = i_zcey;
          i_shww = i_zshw; i_shhh = i_zshh;
        }
      }
      ZoomStatus = 0;
    }

    if (X_shift) {
      i_cenx += X_shift;
      X_shift = 0;
    }

    if (Y_shift) {
      i_ceny +=  Y_shift;
      Y_shift = 0;
    }

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " Half showed sizes (image  pixels) : %d, %d\n", i_shww, i_shhh );
      fflush( stdout );
    }
#endif

    // Compute the display scale (in Display_Pixels/Image_Pixels).
    if (!SetScaVal) {
      rx_scale = (GLfloat)w_hwid/i_shww; ry_scale = (GLfloat)w_hhig/i_shhh;
      r_scale = (rx_scale < ry_scale)? rx_scale : ry_scale;
      if (FirstView&&(r_scale > 1.0)) r_scale = 1.0;
    } else SetScaVal = 0;

    W_zoom->value( r_scale );
    whwid = w_hwid/r_scale; whhig = w_hhig/r_scale;

#ifdef GL_DEBUG        
    if (!MouseStat) {               
      printf( " scale = %10.6f\n", r_scale );
      printf( " Half Display sizes (Image pixels) : %d, %d\n", whwid, whhig );
      fflush( stdout );
    }
#endif

    // Get the future visible image part rectangle limits.
    cur_x1 = i_cenx -  whwid; cur_y1 = i_ceny -  whhig;
    cur_x2 = i_cenx +  whwid; cur_y2 = i_ceny +  whhig;

    // Compute the pixel and row to skip when required.
    if (img_x1 < cur_x1) { i_spix = cur_x1 - img_x1; map_x = cur_x1; }
                    else { i_spix = 0; map_x = img_x1;}
    i_npix = ((img_x2 > cur_x2)? cur_x2 : img_x2) - map_x;

    if (img_y1 < cur_y1) { i_srow = cur_y1 - img_y1; map_y = cur_y1; }
                    else { i_srow = 0; map_y = img_y1; }
    i_nrow = ((img_y2 > cur_y2)? cur_y2 : img_y2) - map_y;

    W_xscroll->value( i_spix, i_npix, 0, i_widt );
    W_yscroll->value( i_high -i_srow - i_nrow, i_nrow, 0, i_high );

#ifdef GL_DEBUG
    if (!MouseStat) {               
      printf( " *** Image space Rectangle : %d, %d, %d, %d\n", cur_x1, cur_y1, cur_x2, cur_y2 );
      printf( " *** Scale = %8.5f, MapSizes = (%d, %d)\n", r_scale, i_npix, i_nrow );
      printf( " *** Skip Pixels,Rows (%d, %d), MapOrg. = (%d, %d)\n", i_spix, i_srow, map_x, map_y );
      fflush( stdout );
    }
#endif

    // Define the showed image space.
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glViewport( 0, 0, w_widt, w_high);  // Set the GL ViewPort.
    glOrtho( (GLfloat)cur_x1, (GLfloat)cur_x2,
             (GLfloat)cur_y1, (GLfloat)cur_y2,
                        -1.0,             1.0
           );
    glEnable( GL_DEPTH );
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();
    
//  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
//  printf( " draw() U %d\n", i_pixs ); fflush( stdout );

    switch (i_pixs) {
      case 1: maptyp = GL_LUMINANCE; break;
      case 3: maptyp =       GL_RGB; break;
      case 4: maptyp =      GL_RGBA; break;
  
    default:
      fl_alert( "DiaViewer: Bad type of imag: %d byte/pixel.", i_pixs );
      maptyp = -1;
      printf( " Bad type of image\n" ); fflush( stdout );
//    exit( 2 );
    }

//  printf( " draw() V %d\n", maptyp ); fflush( stdout );
    if (maptyp>0) {
//    printf( "-----> i_widt=%d, i_spix=%d, i_srow=%d, at (%d,%d)\n", i_widt,i_spix,i_srow, map_x, map_y);
//  fflush( stdout );
      glPixelStorei( GL_UNPACK_ROW_LENGTH,  i_widt );
      glPixelStorei( GL_UNPACK_SKIP_PIXELS,  i_spix );
      glPixelStorei( GL_UNPACK_SKIP_ROWS,    i_srow );
      glPixelStorei( GL_UNPACK_ALIGNMENT,        1 );
      glRasterPos3f( map_x+0.0001, map_y+0.0001, 0.0 );
//    GLboolean valid; glGetBooleanv( GL_CURRENT_RASTER_POSITION_VALID, &valid );
//    printf( " PIxmap Position valid = %d\n", valid );
      glPixelZoom( r_scale, r_scale );
      glDrawPixels(  i_npix, i_nrow, maptyp, GL_UNSIGNED_BYTE, (GLvoid*)Curr_Map );
    }
        
//  printf( " draw() W\n" ); fflush( stdout );
    if (MouseStat) {
      glLineWidth( 2.0 );
      glColor3f( 0.5, 0.5, 0.5 );
      glBegin( GL_LINE_LOOP );
      glVertex3f( zre_x1, zre_y1, -1.0 );
      glVertex3f( zre_x2, zre_y1, -1.0 );
      glVertex3f( zre_x2, zre_y2, -1.0 );
      glVertex3f( zre_x1, zre_y2, -1.0 );
      glEnd();
    }        
  }
//  printf( " draw() X\n" ); fflush( stdout );

#ifndef MESA
  glDrawBuffer(GL_BACK);
#endif // !MESA

//printf( " Draw Process End\n" ); fflush( stdout );
} // void DiaViewer_GL::draw().



//
// end of <PW-Id>.
//
