//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to analyse a directory tree.
//
//


#ifndef SERVICE_DIR_H
#define SERVICE_DIR_H

//#include <sys/stat.h>
//#include <string.h>


#include "Service_RE8STK.h"
#include "Service_STACK.h"
#include "Service_UTIL.h"



#ifndef DFREF_NAME_CMP
# define DFREF_NAME_CMP( id1, id2 ) strcmp( id1, id2 )
#endif

#define MAX_DIR_NESTING 32

/*
//
// Define this common type inside SrvDir.
//
typedef char        * Item;

//
// We describe here the files tree description as build by SrvDir tools.
//
class DirItem {
public:
private:
    Item                diref_; // The Item to keep the kind  and the name of directory.
    DirItem          ** dilst_; // Table of selected subdirectory references
    Item              * filst_; // Table selected Files references.
    int         ndir_,   nfil_; // The number of subdirectory and files references.

public:
    DirItem( Item it ) { diref_ = it; dilst_ = 0; filst_ = 0; ndir_ = nfil_ = 0; }
    ~DirItem() { if (diref_) delete[] diref_; delete[] dilst_; delete[] filst_;  }

    void      Init( int nd, int nf ) { dilst_ = new DirItem *[nd]; filst_ = new Item[nf]; }

    Item      DirRef() { return diref_; }
    int       NumDir() { return ndir_; }
    int       NumFil() { return nfil_; }

    void      PutDirRef( int i, DirItem * d ) { dilst_[i] = d; }
    DirItem * GetDirRef( int i ) { DirItem * p = dilst_[i]; dilst_[i] = 0; return p; }

    void      PutFilRef( int i, Item n ) { filst_[i] = n; }
    Item      GetFilref( int i ) { return filst_[i]; }

    void      Zero() {
        diref_ = 0;
        for(int i=0;i<ndir_;i++) dilst_[i] = 0;
        for(int i=0;i<nfil_;i++) filst_[i] = 0;
    }
};

*/

class SrvDir {
public:
    typedef struct {            // Define the Record type for Tree structure.
        UInt16            knd_; // Kind of Dir entry.
        char         nam_[256]; // Filename.
    } FDRef;
    typedef FDRef * FDAcc;      // Define the access pointer for a FDRef.

    typedef struct DND {
        FDAcc          ref_,    // File/Directory Reference (kind + filename).
                    * fitb_;    // File table origine in filstk_.
        struct DND ** ditb_;    // Sub-directory table origine in dirstk_.
        UInt16        ndir_,    // Number of sub-directories.
                      nfil_,    // Number of files.
                     cndir_,
                     cnfil_;
    } DirNode;
    typedef DirNode * DNAcc; // Define the access pointer for DirNode.


    // Use do define a user catch error.
    typedef int (*ErrCatch_t) ( int, const char * );

    // When these next routines return 0, the directory/file will be ignored.
    typedef int (*DirBegin_t) ( const char * );
    typedef int (*DirEnd_t)   ( int, int );
    typedef int (*DirFile_t)  ( int, const char * );

    // Define a file types list.
    typedef char    ** FTypLst;

    typedef enum {
        Dir_MLink =  1, // Scan take in account the multi-link [default No].
        Dir_SLink =  2, // Scan take in account the symbolic links [default No].
        Dir_NCase =  4, // Suppress the case distinction [default No.].
        Dir_NSort =  8
    } Dir_Flags_t;

    FDAcc              * fitb_, // The Table origine and Stack pointer ...
                       * fisp_, // ... for the files and ...
                       * ditb_, //
                       * disp_; // ... for the directories.
    DNAcc              * dntb_, // Table origine and Stack pointer...
                       * dnsp_; // ... for directory node stack.

    Any_Re8Stk<FDRef>  fddref_; // Define the heap for the FDRef record (Kind + filename), ...
    Any_STK<DirNode>   dnodem_; // Define the heap for DirNodes.

    Any_Table<FDAcc>   filtab_, // ... there respective array of reference pointers ...
                       dirtab_; // ... that are also used for the optional filenames sort.

    Any_Table<DNAcc>   dintab_; // The table of keep directory.
    DirNode ndtab_[MAX_DIR_NESTING];
    DirNode            * ndsp_; // Node stack pointer.

    Any_STK<DirNode>    ndstk_;

private:

    ErrCatch_t           ehdl_; // Call on error with argument error code.
    DirBegin_t           dibg_; // Call with argument the directory filename.
    DirEnd_t             dien_; // Call with arguments numbers of directories and regular files.
    DirFile_t            rfil_; // Call with arguments related file type index and filename.

    FilePath             path_; // File/Directories Path Manager.
    FTypLst             typls_; // List of matching regular file types.
    int                  flgs_, // Scan Flags.
                       * fkey_, // File types kind (used to manage file types synonymes.
                         nerr_, // The error count.
                         nlvl_; // The Directory nesting level from Base/root.

    int                ccnfil_, // cumulative counts of files and folders.
                       ccndir_, //
                          ierr; // Class error code.


    const char * DFRefName( FDRef * rf ) { return rf->nam_; }
    int          DFRefKind( FDRef * rf ) { return rf->knd_; }

    // Two methods for sort functions (working with Item type).
    void FDRef_SimplSort( FDRef **, int, int );
    void FDRef_QuickSort( FDRef **, int, int );
    void FDRef_Sort( FDRef **, int, int );

    FDAcc   CreateRef( int, int, const char * = 0 );
    DNAcc   CreateDNode( FDRef * , int, int, int, int, FDAcc *, DNAcc * );


    int     Check_FName( const char * );

    int     Error_Manager( int, const char *, ... );

    void    Sext_NCase();

    int     ScanMan( DirNode * );

    DNAcc   Scan_Dir( FDAcc );
    int     Scan_Works( DirNode * );
    int     Scan_Work1();


protected:
//  Item ItemEncode( int, const char * );
//  const char * ItemName( Item it ) { return it+1; }
//  int ItemKind( Item it ) { return it[0]; }

    DNAcc        root_; //  The Root dit=rectory descriptor.


    virtual int ErrMan( int, const char * );    // Call when an error is detected.
                                                // Call Model : ErrMan( <Error_Number>, <related_message); .
                                                // <Error_Number> > 0 : we continue scan as it possible,
                                                //                < 0 Fatal error, we stop the scan.
                                                // The returned value must -1 to stop the scan and -2 ...
                                                // ... to stop on too many errors.

    virtual int Filter( int, const char * );    // Call to select a directory entry (file or directory).
                                                // Call Model :  knd = StartDir( 0, <directory_name> ); or
                                                //               knd = StartDir( 1, <file_name> ); .
                                                // if knd >= 0 : The entry is selected and its value gives
                                                //               the choice number in the choice list or 1.
                                                //    knd <  0 : The entry is not selected.

    virtual int StartDir( const char * );       // Call before to scan a directory.
                                                // Call Model : ie = StartDir( 0, <directory_name> );
                                                // if ie < 0 the scan is stopped.

    virtual int EndDir( int, int );             // Call when a directory scan is finished.
                                                // Call Model : ie = EndDir( <ndir>, <fil> ); ...
                                                // where <ndi>r and <nfil> are thes elected number ...
                                                // ... of directory and files.

    virtual int SelFile( int, const char * );   // Call when a file is selected.
                                                // Call Model : ie = SelFile( <knd>, <directory_name> );
                                                // if ie < 0 the scan is stopped.


public:
    SrvDir();
    ~SrvDir(); // Destructor.

    // Enable the SrvDir Structure with :
    //    DirFTyp arg, the list of accepted type/ext. of file entries (ended by NULL),
    //    a flag 
    //    and in last arg., the path of root directory.

    // Routine To Clean User routines pointers.
    // Warning ! This routine should not be used in the coroutines called by scan.
    void Clean() { ehdl_ = 0; dibg_ = 0; dien_ = 0; rfil_ = 0; nerr_ = 0; nlvl_ = -1; }

    void SetFlg( int v ) { flgs_ |= v; }
    void ClrFlg( int v ) { flgs_ &= ~v; }
    int  TstFlg( int v ) { return flgs_ & v; }

    // To set an user catch routine (else a default error message is produced).
    void ErrHdl( ErrCatch_t r ) { ehdl_ = r; }
    void ErrZero() { nerr_ = 0; }

    // Setup the scan process.
    // Arg 1 : The routine called when a directory is found,
    // Arg 2 : The routine called when a end of directory is reached.
    // Arg 3 : The routine called when a regular file is matching.
    // Warning ! This routine should not be used in the coroutines called by scan.
    void Setup( DirBegin_t dibg, DirEnd_t dien, DirFile_t rfil )
        { dibg_ = dibg; dien_ = dien; rfil_ = rfil; }

    // To specify the file type list (ended by 0) end file ntype number (for synonymes).
    void SetFltExt( const FTypLst = 0 );

    // Perform the Tree Scan process to find any file of specified types.
    // The unique argument is the base/root of the directories/files tree.
    // A return != 0 is used to signal error during the scan.
    int  Scan( const char * );

    // To get the complete path of the object (to use in the user co-routines). 
    const char * Path() { return path_.Path(); }

    // To get the internal nesting level (or current relative directory deep).
    int NestLevel() { return nlvl_; }

    // The Main fonction to scan and build the Tree explorations structures.
    int  BuildTree( const char * );


};



#endif


//
// end of <PW-Id>.
//
