//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage Indexed Files 
//
//

#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdio.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>

#include "Service_IndexIO.h"



SrvInFile::SrvInFile( const Header * fhl ) {
    hl_ = fhl; ind_ = 0; fp_ = NULL; ehdl_ = NULL; mnam_ = path_ = NULL;
} // (private) SrvInFile::SrvInFile( const Header * fhl ).



SrvInFile::~SrvInFile() {
    hl_ = NULL; fp_ = NULL; ehdl_ = NULL;
    if (mnam_) delete[] mnam_; if (path_) delete[] path_;
    bll_.Clean();
} // (private) SrvInFile::~SrvInFile().



void SrvInFile::IOError( int cod, const char * msg )
//
// IO Error routine.
//
// Used Routine to generate all file context attached error message.
//
{
    if (cod > 0)
        fl_message( " * %s Warning # %d : %s\n * file\" %s\"", mnam_, cod, msg, path_ );
    else {
        fl_alert( " * %s Error # %d : %s \n * file \"%s\"", mnam_, -cod, msg, path_ );
        Close();
        if (ehdl_) ehdl_( cod );        // Call user catcher to finish the current action.
    }
} // (private) void SrvFile::IOError( int cod, const char *msg ).



int  SrvInFile::Close()
{
    
    ind_ = 0;
    return 0;
} // int  SrvInFile::Close().



int  SrvInFile::Open( SrvInFile * fl, const char * fname, const Header * fhl, const char * md )
{
    Header  head, rdhd;
    int         ie = 1, // Assume Success.
              sz0, sz1;

    if (fp_) { fclose( fp_ ); delete[] path_; }
    if (md) mnam_ = md;
    fp_ = fopen( fname, "rw" );
    if (!fp_) {
        if (errno != ENOENT) {
            fl_alert( " * %s : Cannot Open file \"%s\"\n * Error : %s\n",
                      mnam_, fname, strerror( errno ) );
            ie = -1;
        }  else {
            
        }
    } else { // fopen success.
        if (fhl) hl_ = fhl;
        path_ = strdup( fname );
        
    }
    return 0;
} // SrvInFile * SrvInFile::Open( const char * path, const Header * hde ).



UInt32 SrvInFile::Put( const Ind_Blk * blk ) {
    
    return 0;
} // UInt32 SrvInFile::Put( const * Ind_Blk blk ).



int  SrvInFile::Get( UInt32 key,  Ind_Blk * &blk ) {
    
    return 0;
} // int  SrvInFile::Get( UInt32 key,  Ind_Blk & *blk ).



int  SrvInFile::Remove( UInt32 key ) {
    
    
    return 0;
} // int  SrvInFile::Remove( UInt32 key ).



//
// end of <PW-Id>.
//
