//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to manage Indexed Files 
//
//

#ifndef SERVICE_IND_IO_H
#define SERVICE_IND_IO_H


#include <stdio.h>

#include "Service_Util.h"
#include "Service_IO.h"


typedef struct IND_BLK {
    UInt16       len_;
    UChar      * dat_;
} Ind_Blk;



class SrvInFile {
public:
    typedef void (*ErrCatch_t) ( int ); // Define the Function trap error type.
    typedef char            Header[16]; // Define the version type context header string.

    
private:
    int           ind_; // The current index position.
    FILE         * fp_; // File pointer.
    const Header * hl_; // File header models list (the first is used for creation).
    ErrCatch_t   ehdl_; // User Error handler.
    const char * mnam_, // Module name for error messages.
               * path_; // Path of the current opened file.

    ObjTable      bll_; // Memory record table.

    void IOError( int, const char * );

    SrvInFile( const Header * fhl );
    ~SrvInFile();

public:
    int Open( SrvInFile *, const char *, const Header * = NULL, const char * = NULL );
    int Close();

    UInt32 Put( const Ind_Blk * );
    int Get( UInt32, Ind_Blk * & );
    int Remove( UInt32 );
    
};



#endif

//
// end of <PW-Id>.
//
