//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to Allocate and store a large number of User Object in a stack.
//
// These object (type Record) can have differente size on the same stack and ...
// ... the memory sytem used minimize the call of memory allocator in large ...
// ... Area of memory.
//
//

#include <string.h>

#include "Service_ENV.h"
#include "Service_RECSTK.h"



void RecStk::URecCopy( Record * dst, Record * src, int sz )
// Warning : We make assumption that the src and dst are UInt32 ...
// ...  aligned and sz is the size of object in bytes.
{
    if (sz & 1) { dst->ch[sz] = src->ch[sz]; sz >>= 1; }
    if (sz & 1) { dst->sw[sz] = src->sw[sz]; sz >>= 1; }
    while (sz >= 0) { dst->sl[sz] = src->sl[sz]; sz--; }
} // void RecStk::URecCopy( Record * dst, Record * src, int sz ).



RecStk::Area * RecStk::NewArea()
{
    Area * p = new Area;
    p->nxt_ =                0; // Presently, no next Area, but the ...
    p->prv_ =             lst_; // ... previous one always exist.
    p->top_ =   p->thd_ =    0; // This new Area is empty and now ...
    p->tab_[0]          =    0;

    lst_->nxt_  = lst_  =    p; // ... our Area is the next of previous one.
    return p;
} // RecStk::Area * RecStk::NewArea().



void RecStk::DelArea( Area * p )
{
    if (lst_ != fst_) { // We cannot try to delete the first Area.
        p->prv_->nxt_ = p->nxt_;
        if (p->nxt_) p->nxt_->prv_ =  p->prv_;
        p->nxt_ = p->prv_ = 0;
    }
} // Area * RecStk::DelArea().



void RecStk::Init()
{
    fst_ = lst_ = cur_ = own_ = &area_;
    fre_           = 0;

    area_.nxt_     = 0;
    area_.prv_     = 0;
    area_.top_     = 0;
    area_.tab_[0]  = 0;
    area_.thd_     = 0;
    fst_->nxt_     = 0;
} // RecStk::Init().



void RecStk::Zero()
{
    fst_ = fst_->nxt_;
    while (fst_) {
        lst_ = fst_->nxt_; fst_->nxt_ = 0;
        delete fst_; fst_ = lst_;
    }
    Init();
} // void RecStk::Zero()



RecStk::Record * RecStk::Push( Record * rec, int len )
// When we have a pre-allocated Record to copy in the stack.
// The Header data fields must be assigned by the user and len ...
// ... is the size of Record (in bytes) including the user header.
// The R_8STK Version is restricted at maximum Record size of 254 bytes ...
// ... and the Records can include (for direct use without copy) only ...
// ... base types fields char/SChar/UChar, SInt_8/UInt_8, and SInt16/UInt16.
// ... For the others types, as float, double, and any pointers they can be stored ...
// ... in Record but there alignement constraints are not be garanteed ...
// ... if the Record is not copied from the stack.
// The R16STK Version is restricted at maximum Record size of 4092 bytes ...
// ... but this stack system is intended to store small records of unequal sizes ...
// ... at the risk of misusing the available memory. Alignment constraints only ...
// ... concern double base types and pointers (in the case of pointing to 64-bit systems.
//
{
    Area           * p;
    HeadRec        * h;
    Record         * r;
    SInt32 ll, phd, ns;

    ll = ((len + 3)>>2);                //* Get total size of the Record (in long words).
    ns = ll + 1;                        //  Add the header size( 2 UInt16 = 1 UInt32).
    p = cur_;                           //  Try to get room in the current Area.
    if ((p->top_+ ns) > AREA_SIZE_L) {  //* When the remaining space is too small ...
        if (p->nxt_) p = p->nxt_;       //  The next area was already allocated.
        else       p = NewArea();       //  Allocate a new Area, and link it with the previuos one.
        cur_ = p;                       //  This new area is the new current one.
    }
    phd = p->top_;                      //  Keep the index of the new HeadRec.
    h = (HeadRec*)(p->tab_ + p->top_);  //  Now h -> new Record descriptor.
    h->he_.link_ =  phd - p->thd_;      //  We fill it (quantity in number of UInt32) ...
    h->he_.size_ =             ns;      //  ... in UInt16 (link_ and size_).
    p->top_ += ns;                      //  Set the new top of stack.
    p->thd_ = phd;                      //  Set the new HeadRec index for next Push on stack.

    own_ = cur_; fre_ = p->thd_;        //  Set the last element position (Area and Header index).
    r = (Record*)(p->tab_ + phd + 1);   //  Now spt_ -> User record location.

    URecCopy( r, rec, len  );           //* Copy User record in the stack ...
    return r;                           // ... and return the address tu caller.
} // RecStk::Record * RecStk::NewRec( int k, char * s ).



RecStk::Record * RecStk::Get( int fl )
{
    Record * r;

    if (fl) r = (Record*)(own_->tab_ + fre_ + 1);
    else    r = (Record*)(cur_->tab_ + cur_->thd_ + 1);
    return r;
} // RecStk::Record * StrMem::Get().



int  RecStk::Size( int fl )
// Return the size in bytes.
{
     HeadRec *h;

     if (fl) h = (HeadRec*)(own_->tab_ + fre_);
     else h = (HeadRec*)(cur_->tab_ + cur_->thd_);
     return (h->he_.size_)*4;
} // int RecStk::Size().




RecStk::Record * RecStk::Remove( Record * r )
{
    Area           * p;
    HeadRec        * h;
    Record         * e;
    int              l;

    p = cur_;                                   // Start from the current Area.
    if (p == &area_ && !p->top_) return 0;      // Return 0 when the stack is empty.

    if (!r) r = Get();                          // When no Record is specified, ...
                                                // ... we select the top of stack.
    p = cur_;                                   // We start frm the current Area.
    do {                                        // Loop on Area.
        l = p->thd_;                            // For this Area, start from its top HeadRec.
        do {                                    // Loop on Record in this Area.
            h = (HeadRec*)(p->tab_ + l);        // Get the HeadRec address and ...
            e = (Record*)(p->tab_ + l+1);       // ... the related Record address.
            l -= h->he_.link_;                  // get the previous HeadRec index.
        } while (r != e && l >= 0);             // Stop Loop When r is found or r not in the Area.
        if (l < 0) {                            // If not found in this Area.
            p->top_ = p->thd_ = 0;              // Set this Area as empty and ...
            p = p->prv_;                        // ... try to skip to previous Area.
            if (p) l = p->thd_;                 // If this Area exist, get the top HeadRec index.
        }
    } while (p && l >= 0);                      // Continue search if the previous Area is found.
    if (p) {                                    // When we have found the last Record to remove ...
        p->top_  = l;                           // ... set the new top of this Area ...
        l -= h->he_.link_;                      // ... and get the previous header index.
        p->thd_ = (l >= 0) ? l : 0;             // and set index of present or futur HeadRec ?.
        e = (p->top_ > 0) ? (Record*)(p->tab_ + l+1) : 0;       // and return the new top record Addr.
        own_ = cur_ = p; fre_ = l;              // Select the new top record.
    } else {                                    // Return 0 when not found (but the stack is now empty).
        p = own_ = cur_ = &area_;               // Mark base area as empty.
        p->top_ = p->thd_ = fre_ = 0;
        e = 0;
    }
    return e;
} // RecStk::Record * Re8Stk::Remove( Record * ).



RecStk::Record * RecStk::Remove( int idx )
{
    Area           * p; // Local Current Area pointer
    HeadRec        * h; // Pointer of the current HeadRec.
    Record         * r; // Pointer of resulting top Record.
    int              l; // Current index of HeadRec.

    p = cur_;                                   // We start frm the current Area.
    if (p == &area_ && !p->top_) return 0;      // Return n0 when the stack is empty.

    do {                                        // Loop on Area.
        l = p->thd_;                            // For this Area, start from its top HeadRec.
        do {                                    // Loop on Record in this Area.
            h = (HeadRec*)(p->tab_ + l);        // Get the HeadRec address and ...
            l -= h->he_.link_;                  // get the previous HeadRec index.
        } while (++idx < 0 && l >= 0);          // Stop Loop When r is found or r not in the Area.
        if (l < 0) {                            // If not found in this Area.
            p->top_ = p->thd_ = 0;              // Set this Area as empty and ...
            p = p->prv_;                        // ... try to skip to previous Area.
            if (p) l = p->thd_;                 // If this Area exist, get the top HeadRec index.
        }
    } while (p && l >= 0);                      // Continue search if the previous Area is found.
    if (p) {                                    // When we have found the last Record to remove ...
        p->top_  = l;                           // ... set the new top of this Area ...
        l -= h->he_.link_;                      // ... and get the previous header index.
        p->thd_ = (l >= 0) ? l : 0;             // and set index of present or futur HeadRec ?.
        r = (p->top_ > 0) ? (Record*)(p->tab_ + l+1) : 0;    // and return the new top record Addr.
        own_ = cur_ = p; fre_ = l;              // Select the new top record.
    } else {                                    // Return 0 when not found (but the stack is now empty).
        p = own_ = cur_ = &area_;               // Mark base area as empty.
        p->top_ = p->thd_ = fre_ = 0;
        r = 0;
    }
    return r;
} // RecStk::Record * Re8Stk::Remove( Record * ).



int  RecStk::Pop( Record * r )
{
    int    ns = Size();                 // Get the size (bytes) of Record at top ...
    Record * e = Get();                 // ...  of stack and get it.

    if (e && ns) {
        URecCopy( r, e, ns  );          // Copy this record to Record location.
        Remove( e );
        return 0;
    } else return -1;
} // int  RecStk::Pop( Record & r ).



RecStk::Record * RecStk::RecNb( int idx )
//
{
    Area           * p;
    HeadRec        * h;
    int              l;

    p = cur_;                           // To begin get the pointer of top Area.
    do {                                // Loop to search across all Area.
        l = p->thd_;                    // Inside Area, get the top RecHeader position.
        do {                            // Loop to search in a Area.
            h = (HeadRec*)(p->tab_+l);  // Get the RecHeader location.
            l -= h->he_.link_;          // Update l to get location of the previous RecHeader.
        } while (idx++ < 0 && l >= 0);
        if (idx>= 0) break;             // When we have find the Record.
        p = p->prv_;                    // Continue in the previuos Area.
    } while (p && idx < 0);
    if (idx < 0) { own_ = &area_; fre_ = 0; return 0; }

    own_ = p; fre_ = l;                 // Update Ower Area pointer and address of header.

    return (Record*)(p->tab_ + l+1);    // Return the user Record location.
} // RecStk::Record * RecStk::RecNb( int idx ).



RecStk::Record * RecStk::NextUp()
{
    Record * r = 0;
    HeadRec    * h;

    if (fre_) {
        if (own_->thd_ <= fre_)  {      // When the record is at top of current Area ...
            if (own_ == lst_) return 0; // If this Area is the last (at top of stack) ...
                                        // ... we return 0 to signal stack overflow.
            own_ = own_->nxt_;          // Find the a upper Record in the Upper Area.
            fre_ = 0;
            r = (Record*)(own_->tab_ + 1);
        } else {                        // When we have some others record under the current.
            h = (HeadRec*)(own_->tab_ + fre_);
            fre_ = h->he_.size_;
            r = (Record*)(own_->tab_ + fre_+1);
        }
    }
    return r;
} // RecStk::Record * RecStk::NextUp().



RecStk::Record * RecStk::NextDown()
{
    Record * r = 0;
    HeadRec    * h;

    if (!fre_) {                        // When  is at a begin of Area.
        if (own_ == &area_) return 0;   // When we was on the first Record of the stack ...
                                        // ... we return 0 to signal the stack underflow.
        own_ = own_->prv_;              // else, we go to the previous Area and ...
        fre_ = own_->thd_;              // .. take the Header index top of this Area.
        r = (Record*)(own_->tab_ + fre_ + 1);
    } else {
        h = (HeadRec*)(own_->tab_+fre_);        // We get the header of current Record ...
        fre_ -= h->he_.link_;                   // ... and index fre_ on the previous record ...
        r = (Record*)(own_->tab_ + fre_+1);     // ... to get the Address of down Record.
    }
    return r;
} // RecStk::Record * RecStk::NextDown().



void RecStk::Statistic(int &na, int &ne, int &sz )
{
    Area           * p;
    HeadRec        * h;
    int   ia,  ir,  mt;
    int        il,  ih;

    ia = ir = mt = 0;
    p = fst_;
    while (p) {
        ia++;
        ih =  p->thd_;
        if (p->top_ > 0) {
            do {
                h = (HeadRec*)(p->tab_+ ih);
                mt += h->he_.size_;
                ir++;
                il  = h->he_.link_;
                ih -= il;
            } while (il > 0);
        }
        p = p->nxt_;
    }
    na = ia; ne = ir; sz = mt;
} // void RecStk::Statistic(int &na, int &ne, int &sz ).


//
// end of <PW-Id>.
//
