//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Module of service routines/objects.
//

#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "Service_UTIL.h"


#define PATH_ALLOC_STEP 256
#define TABL_ALLOC_STEP  16
#define MAX_LOG_LENGTH   32

//
// Functions for Temporary string allocations/free class VarString.
//

void VarString::Setup( int cop, int inc , int all ) {
    if (all <= 0) all_ = 0;
    else { all_ = 32; while (all_ < all) all_ *= 2; }
    inc = (inc > 0) ? ((inc < 16)? 16 : inc) : 0;
    inc_ = 16; while (inc_ < inc) inc_ *= 2;
    cop_ = cop;
    if (all_) str_ = new char[all_];
    else str_ = 0;
} // char * VarString::Setup( int inc, int all ).



char * VarString::Size( int size )
{   char        * nst_;

    size++;                             // Add one for the final null character.
    if (inc_ > 0  && all_ < size) {     // We must increase the string allocation.
        all_ = (size + inc_)&~(inc_-1); // Force the new size to be a multiple of inc_.
        nst_ = new char[all_];          // Allocate the new string space.
        // Copy the old string in the new one when required.
        if (cop_&&str_&&str_[0]) strcpy( nst_, str_ );
        else nst_[0] = 0;
        if (str_) delete[] str_;// Free old string.
        str_ = nst_;
    } else if (size > all_) return 0;
    return str_;
} // void VarString::Allocate( int size ).



//
// **********************************************************************************
//


//
// Class FilePath to manage a dynamic file path.
//


FilePath::~FilePath()
{
    if (path_) delete[] path_;
    if (stack_) delete [] stack_;
    path_ = 0; stack_ = 0;
} // FilePath::~FilePath().


FilePath::FilePath( int inc, char * tab ) {
    if (tab) {          // When a local (char array or pointer != 0 is given) ...
        increm_ = 0;    // ... set the increment for reallocation to zero, ...
        path_ = tab;    // ... Set the user char* variable as the stack array, ...
        allsiz_ = inc;  // ... and take the user increment argument as the allocated size.
    } else {            // For dynamic allocation mode ...
        path_ = 0;
        if (inc <= 8) increm_ = PATH_ALLOC_STEP;
        else {
            increm_ = 8;
            while (inc < increm_) increm_ *= 2;
        }
        stack_ = 0; allsiz_ = sl_ = 0;
    }
    length_ = 0; sl_ = 0; sp_ = -1;

}

int FilePath::Set( const char * name, int dfl )
//
// Set a string in *PathString to be the path of the new file of directory.
// SetFilePath return the old PathString length to be reset to old value by
// the routine RemFilePath( int ).
// When the argument name is NULL the PathString is preserved.
// The argument dfl is used to set or remove a terminated Directory separator
// in all case, (name argument provided of NULL).
//
{
    int len_, oln_, usz_;
    int siz_,      * tm_;
    
    oln_ = length_;
    if (name) {
        len_ = strlen( name );
        siz_ = len_ + length_ + 2;
        if (allsiz_ < siz_) {
            if (increm_) {
                usz_ = siz_;
                // Allocated size round up to a multiple of PATH_ALLOC_STEP.
                allsiz_ = (usz_ + increm_)&~(increm_-1);
                char * tmp_ = new char[allsiz_];
                if (path_) {
                    strcpy( tmp_, path_ );
                    delete[] path_;
                }
                path_ = tmp_;
            } else return -1;
        }
        usz_ = length_ + len_;
        strcpy( path_ + oln_, name );
    
        sp_++;
        if (sl_ <= sp_) {
            sl_ = (sl_ + TABL_ALLOC_STEP)&~(TABL_ALLOC_STEP - 1);
            tm_ = new int[sl_];
            if (sp_ > 0) {
                for(int ii = 0; ii < sp_; ii++) tm_[ii] = stack_[ii];
                delete[] stack_;
            }
            stack_ = tm_; tm_ = 0;
        }
        stack_[sp_] = oln_;
    } else usz_ = length_;

    if (usz_ > 0) {
        if (path_[usz_-1]!=DIR_SEPAR) {
            if (dfl) {
                path_[usz_++] = DIR_SEPAR;
                path_[usz_] = 0;
            }
        } else {
            if (!dfl) path_[--usz_] = 0;
        }
    }
    length_ = usz_;
   return oln_;
} // int FilePath::Set( const char * name, int dfl ).



const char * FilePath::LastName()
{
    char * pnm = 0;

    if (stack_ && path_) {
        if (sp_ >= 0) pnm = path_ + stack_[sp_];
        else pnm = path_;
    }
    return pnm;
} // FilePath::LastName().



int FilePath::Rem()
{
    int ie = 0;

    if (stack_) {
        if (sp_ >= 0) length_ = stack_[sp_--];
        else ie = -1;
    }
    path_[length_] = 0;
    return ie;
} // int FilePath::Rem( int vl ).



void FilePath::Clear()
{
    if (path_) path_[0] = 0;
    length_ =  0;
    sp_     = -1;
} // void FilePath::Clear().



void FilePath::BuiltIter( const char * pt )
{
    const char   * cp, * vp;
    char  ch, lg[MAX_LOG_LENGTH];
    int                  ii;

    cp = strchr( pt, DEV_SEPAR );       // Look for ':' (return 0 if not found).
    if (cp) {                           // When found ...
        vp = cp -  1;                   // ... vp -> last character of device name.
        ii = cp - pt;                   // ii = size of device name.
        if (ii >= MAX_LOG_LENGTH) exit( 2 );
        lg[ii]  =  0;                   // Copying the device name in major case.
        while (ii--) {
            ch =*(vp--);
            if (ch >= 'a' && ch <= 'z') ch += 'A' - 'a';
            lg[ii] = ch;
        }
        vp = getenv( lg );              // If it is a logical device name, get it corresponding path.
        if (vp) {                       // We hae the logical device translation.
            BuiltIter( vp );            // Loop for more internal logical reference ...
            pt = cp + 1;                // ... and skip the device separator.
        }
        Set( NULL, 1 );
    }
    if (pt[0]) Set( pt, 0 );            // Put in path the traling path specifications.
} // void FilePath::BuiltIter( const char * pt ).




int  FilePath::PathSearch( const char * PathList, const char * fname )
// Look for the first existing path in Pathlist (with optional filename).
// The reulting path is keep in the FilePath object and the the return value
// is the path entry index (starting from 1) when found or else 0.
//
{
    const char        *cu, *lm;
    char             buf[1024];
    int             ii, jj, ne;

    cu = PathList;                              // Start scan from the begin of Path List.
    jj = ne = 0;
    do {                                        // Loop on all Path of the path list.
        jj++;
        Clear();                                // Erase any previous path.
        ii = 0;
        lm = strchr( cu, PAT_SEPAR );           // Look for the first/next path separator.
        if (!lm) lm = cu + strlen( cu );        // If not found, this path is the last one.
        while (cu != lm) buf[ii++] = *(cu++);   // We copy this path in our buffer (no overflow checking).
        buf[ii] = 0;
        BuiltIter( buf );                       // Get the translation of any logical device reference in this path.
        if (fname) {                            // When an additional filename is specified ...
            Set( NULL, 1 );                     // ... we append it in the path.
            Set( fname, 0 );
        }
        // We check if the file or directory is existing.
        if (!access( Path(), F_OK)) { ne = jj; break; }
        // When it is not existing, skip the path separator (when not last path) ...
        if (*cu == PAT_SEPAR) cu++;             // ... and loop for the next path.
    } while (*cu);
    return ne;                                  // Return the path index (starting from 1).
} // const char * FilePath::PathSearch( const char * pathList, const char * fname ).




// --------------------------------------------------------------------------------


//
// Object table class routines to manage a tabel of undefined objects.
//

void ObjTable::Clean()
{
    if (tab_) delete[] tab_;
    use_ = all_ = 0; tab_ = 0; utb_ = usp_ = 0;
    inc_ = TABL_ALLOC_STEP;
} // void ObjTable::Clean().



void ObjTable::IniAlloc( int size )
{
    int rsz = 32;

    if (!tab_ && !use_ && inc_) {
        while (rsz < size) rsz *= 2;
        tab_ = new AccPtr[rsz];
        all_ = rsz;
        if (utb_) *utb_ = tab_;
        if (usp_) *usp_ =    0;
    }
}

void ObjTable::Setup( int inc, AccPtr * tab, AccPtr * usp )
{
    inc_ = 16;
    while (inc_ < inc) inc_ *= 2;
    if (tab) { utb_ = &tab; *utb_ = tab_; }
    if (usp) { usp_ = &usp; *usp_ = 0; }
} // void ObjTable::Setup( AccPtr * tab, AccPtr * usp ).



int  ObjTable::AddObj( AccPtr p )
{
    AccPtr *tm;
    int   size;

    size = use_ + 1;
    if (size >= all_) {
        size = (size + inc_)&~(inc_ - 1);
        tm = new AccPtr[size];
        if (use_)
            for(int ii = 0; ii < use_; ii++) tm[ii] = tab_[ii];
        if (tab_) delete[] tab_;
        tab_ =   tm;
        all_= size;
        if (utb_) *utb_ = tab_;
    }
    if (usp_) *usp_ = tab_ + use_;
    tab_[use_++] = p;
    return use_;
} // void ObjTable::AddObj( AccPtr p ).



AccPtr * ObjTable::GetObjs( int shf )
{
    if ((shf >= 0)&&(shf < use_))
        return tab_ + shf;
    else
        return NULL;
} // AccPtr * ObjTable::GetObjs( int shf )



void ObjTable::Tamp( int idx )
{
    int  i,  j;

    if ((idx < 0)||(idx >= use_)) return;

    if (tab_) {
        i = j = idx;
        while (i < use_) {
            if (tab_[i]) {
                if (j != i) tab_[j] = tab_[i];
                i++; j++;
            } else i++;
        }
        use_ = j;
        if (usp_) *usp_ = (use_ > 0) ? tab_ + use_ : 0;
    }
} // void ObjTable::Tamp().



void ObjTable::RemObj( int idx )
{
    if ((idx >= 0)&&(idx < use_)) {
        tab_[idx] = NULL;
        this->Tamp( idx );
    }
} // void ObjTable::RemObj( int idx ).



void ObjTable::RemObj( AccPtr p )
{
    int idx = 0;

    while ((idx < use_)&&(tab_[idx] != p)) idx++;
    if (idx < use_) {
        tab_[idx] = NULL;
        this->Tamp( idx );
    }
} // void ObjTable::RemObj( AccPtr p ).
