//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Environment of Service routines/object.
//


#ifndef SERVICE_UTIL_H
#define SERVICE_UTIL_H


#include <stdlib.h>

#include "Service_ENV.h"

#ifndef DIR_SEPAR
#   if defined(WIN32) || defined(__EMX__) && !defined(__CYGWIN__)
#       define DIR_SEPAR '\\'
#   else
#       define DIR_SEPAR '/'
#       define O_BINARY 0
#   endif
#endif

#if !(defined(WIN32) || defined(__EMX__) && !defined(__CYGWIN__))
# define O_BINARY 0
#endif


// Convention for path list (same for all O.S.) :

#define DEV_SEPAR ':'
#define PAT_SEPAR ','



typedef void *                  ObjPtr; // Define a pointer a undefined object.



// By C/C++ convention, the "long int" type has the size of "void *" ...
// ... (32/64 bits follow processor type) (see /usr/include/bits/types.h).

extern const char    UserEnv[], // Path to DiaViewer setup file(s).
                     UserDir[], // Path directory of the user.
                  DiaEnvFile[]; // DiaViewer Setup main filename.


//
// **********************************************************************************
//



//
// class VarString to manage temporary string allocations/free.
//
//

class VarString {
    
private:

    int   all_,   inc_,   cop_; // Alloc. size, Alloc. increment and Copy flag.
    char                * str_; // String pointer.


public:

    VarString( int s = 0, int i = 32, int a = 0 ) { Setup( s, i, a ); }
    ~VarString() { if (str_) delete[] str_; }

    void Setup( int cop, int inc = 0, int all = 0);

    char * String() { return str_; }

    char * Size( int );
    void Clear() { if (str_) delete str_; all_ = 0; }

};




//
// **********************************************************************************
//



//
// Class FilePath to manage a dynamic file path.
//

class FilePath {

private:
    char   * path_;
    int    length_,
           allsiz_,
           increm_;
    int   * stack_;
    int   sl_, sp_;

    void BuiltIter( const char * );
 
public:
    FilePath( int = 0, char * = 0 );
    ~FilePath();

    int          Set( const char *, int = 0 );
    int          Rem();
    void         Clear();
    const char * Path() { return path_; }
    const char * LastName();
    int          Length() { return length_; }
    int          PathSearch( const char *, const char * = 0 );
    
};



//
// **********************************************************************************
//


class ObjTable {
private:
    int           use_, // Used size.
                  all_, // Allocated size.
                  inc_; // Increment of allocation.
    AccPtr      * tab_; // The table of object pointer.
    AccPtr     ** utb_, // User pointer of the table with dynamic update.
               ** usp_; // User table stack pointer with dynamic update.

public:
    void Clean();
    void IniAlloc( int );

    // Object table creator.
    ObjTable() { use_ = all_ = inc_ = 0; tab_ = 0; utb_ = usp_ = 0; }
    // Object table destructor.
    ~ObjTable() { Clean(); }

    void Setup( int, AccPtr * = 0, AccPtr * = 0 );

    AccPtr GetObj( int i ) { return (((i>=0)&&(i<use_))? tab_[i] : 0); }

    // Routine to get a table access from the specified index.
    AccPtr * GetObjs( int shf = 0 );

    int TabUse() {return use_;} // To get the current used table length.

    int       AddObj( AccPtr ); // Append a new object at the table.

    void   Tamp( int idx = 0 ); // To tamp the object table with some null reference(s).

    void      RemObj( AccPtr ); // Remove an object from the table.
    void         RemObj( int );

    int  Push( AccPtr o ) { return AddObj( o ); }
    
    AccPtr Pop() { AccPtr p = 0; if (use_) { p = tab_[use_ - 1]; tab_[--use_] = 0; } return p; }

};



template <class Ty>
class Any_Table : public ObjTable {
public:
    Any_Table<Ty>() : ObjTable() {  }
    inline void  Setup( int i, Ty ** t, Ty ** p = 0 )
                { ObjTable::Setup( i, (AccPtr*)(&t), (AccPtr*)(&p) ); }
    inline Ty    GetObj( int i ) { return (Ty) ObjTable::GetObj( i ); }
    inline Ty  * GetObjs( int s = 0 ) { return (Ty *) ObjTable::GetObjs( s ); }
    inline int   AddObj( Ty o ) { return ObjTable::AddObj( (AccPtr) o ); }
    inline void  RemObj( Ty o ) { ObjTable::RemObj( (void *) o ); }
    inline int   Push( Ty & o ) { return ObjTable::AddObj( (AccPtr) o ); }
    inline Ty    Pop() { return (Ty) ObjTable::Pop(); }
};



#endif

//
// end of <PW-Id>.
//
