

static int TreeCreate( int deep, int idd )
// Recursive Routine to create any path element of a given path ...
// ... and prepare path builting of a new (ranked) volume.
//
{
    int            dii;
    char     dfnam[64];
    const char  * path;

    dii = DeepTab[deep];                // Get the current directory index (or -1 when no existing).
    if (dii != idd) {                   // When the expected directory is not in the current path.
        if (dii >= 0) {                 // When, a previous directory is existing, remove it from path ...
            DstPath->Set( CNTX_FNAME ); // ... after the context file creation.
            CurDref->WriteDirCntxFile( dii, DstPath->Path() );
            CurDref = CurDref->DelRef( CurDref );
            DstPath->Rem();
            DstPath->Rem();
        }
        // Check for parent directory and stop on error.
        if (TreeCreate( deep-1, idd/dirdirsz )) return -1;
        // Build the filename of the expected directory and ...
        snprintf( dfnam, 63, dirfrm, fold_hde, deep, fold_dig, idd, fold_tra );
        DstPath->Set( dfnam, 1 );       // ... put it in the path.
        path = DstPath->Path();         // Keep the complete path and ...
        DeepTab[deep] = idd;            // ... put its index in the deep table.
        if (access( path, F_OK ))       // If the expected directory does nos exist, we create it.
            if (MkDir( path )) return -1;       // On error we return.
//      CurDref = CurDref->NewRef();    // Create the directory/slide reference structure.
        CurDref = new DirRefer(CurDref);// Create the directory/slide reference structure.
    }
    return 0;
} // static int TreeCreate( int deep, int idd ).



static int SlideCopy( SliEntry * sli )
{
    char            nsname[32];
    const char    * src, * dst;

    // Compute the slide index as a combinaison of film and slide numbers.
    int ids = (sli->Film() - 1)*dirslisz + sli->Numb() - 1;
    // Create any subdirectory to be ready to copy the slide.
    if (TreeCreate( DstDeep, ids/dirslisz )) {
        // On error send the message.
        fl_alert( "Error : Cannot use the path \"%s\"\n\t%s\n", DstPath->Path(), strerror( errno ) );
        return -1;
    }
    // Build the new filename (in the new ranked volume) of the slide.
    snprintf( nsname, 31, slifrm, slid_hde, film_dig, sli->Film(), slid_sep,
                                            slid_dig, sli->Numb(), slid_tra );
    // Put it in the path and perform the slide copy.
    DstPath->Set( nsname, 0 );
    src = sli->BltPath();
    dst = DstPath->Path();
    if (access( dst, F_OK)) {
        if (FileCopy( dst, src )) {
            // On error send the message.
            fl_alert( "Error : Cannot copy the slide \"%s\"\n\t%s\n", DstPath->Path(), strerror( errno ) );
            return -1;
        }
    }
    DstPath->Rem();
    CurDref->AddSliRef( nsname, sli );
    return 0;
} // static int SlideCopy( const char * path, SliEntry * osli ).




void Rkg_CreateVolume()
//
// Call to define the new ranked volume path.
//
{
    SliEntry             * sli;
    const char          * root;
    int    flcnt, sliid, fdeep;

    if (Rank_OK <= 1) {
        fl_alert( "You cannot perform the Ranking process.\n\t%s",
                  "before to get success in the Data Check test." );
        return;
    }

    root = rkg_root->value();                           // Get the user root path.
    if (tvol_pth) delete[] tvol_pth;
    tvol_pth = strdup( root );
    if (access( root, F_OK|R_OK|W_OK|X_OK )) {
        if (errno != ENOENT) {
            fl_alert( "Error: Can't create a new volume in the path \"%s\"\n\t%s",
                    root, strerror( errno ) );
            return;
        }
///     char question[256];

        if (fl_choice( "The directory %s does not exist.\n\tDo you want create it ?",
                           "Yes and continue", "Quit", 0, root ))
            return;
        else
            if (MkDir( root )) {
                fl_alert( "Cannot create the directory \"%s\"\n\t%s", root, strerror( errno ) );
                return;
            }
    }

    strncpy( RootPathStr, root, 248 );
    DstPath = new FilePath( DstDeep + 1 );              // Create the destination Path and ...
    DstPath->Set( RootPathStr, 1 );                     // ... set it as root of the new volume.

    CPath = new FilePath( SrcVol->TDeep() + 1 );        // Init the Source Filepath.

    DeepTab = new int[DstDeep+1];                       // Create the deep table to manage the ...
    DeepTab[0] = 0;
    for(int i=1; i<=DstDeep; i++)  DeepTab[i] = -1;     // ... volume tree creation.

    CurDref = new DirRefer( NULL );                     // Create the root reference directory.

    flcnt = 0;
    while (flcnt < Flm_Siz) {                           // Loop one all Films.
        if (FlmTable[flcnt]) {                          // When this Film exist.
            sliid = 0;
            while (sliid < Sli_Siz) {                   // Loop on all slide of the same film.
                if (sli = FlmTable[flcnt][sliid])       // Get the SliEntry reference.
                    if (!(sli->FlgTst( Context_LckRank )))
                        SlideCopy( sli );               // Copy all existing slides ...
                                                        // ... in new volume tree.
                sliid++;
            }
        }
        flcnt++;
    }

    // We must close all pending directory.
    fdeep = DstDeep;
    do {
        DstPath->Set( CNTX_FNAME );                     // Create context files for each not closed directories.
        CurDref->WriteDirCntxFile( fdeep, DstPath->Path() );
        CurDref = CurDref->DelRef( CurDref );
        DstPath->Rem();
        DstPath->Rem();
    } while (fdeep-- );

    delete[] DeepTab;
    delete CPath; CPath = NULL;;
    delete DstPath;

    // Now we must open the new slide volume, ...
    // ... set it all its context data and ...
    // ... save them.
    //


} // void Rkg_CreateVolume().



