//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Native_File_Chooser.H>
#include <FL/Fl_Text_Buffer.H>

#include "Text_Service.h"


/*
#define TXT_SRV_DEBUG
*/



void TxtSave( Fl_Text_Buffer * buf )
{
    char * fpath = fl_file_chooser( "Save File as", "*.txt", "DiaViewer_Rank_Check.txt", 0 );
    FILE *   fp;
    char * text;
    char     ch;
    int   i = 0;

    if (fp = fl_fopen( fpath, "w" )) {
        text = buf->text();
        while (ch=text[i++]) {
            putc( ch, fp );
        }
        fclose( fp );
    } else {
        fl_alert( "Error : Cannot create the file %s\n\t error message %s\n",
                  fpath, strerror( errno ) );
    }
} // void TxtSave().



void TxtPrint( Fl_Text_Buffer * buf )
{
    
}



#ifdef TXT_SRV_DEBUG


int main( int argc, char ** argv )
{
    FILE      * fp;
    char line[256];
    char *     str;


    if ((argc<=1)&&!argv[1]) {
        fl_alert( " No file was specified => stop" );
        return 1;
    }
    
    DspTxt = new Text_DisplayUI( argv[1] );


    if (fp = fl_fopen( argv[1], "r" )) {
        while (str = fgets( line, 255, fp )) {
            printf( " line = %s", line );
            // if (DspTxt->txt_buffer->text()) DspTxt->txt_buffer->text( str );
            DspTxt->txt_buffer->append( str );
        }
        fclose( fp );
        Fl::run();
    } else  {
        fl_alert( "The File %s cannot be opened", argv[1] );
        return 1;
    }
    return 0;
} // int main( int argc, char ** argv ).


#endif


//
// end of <PW-Id>.
//

